/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.processor;

import io.agrest.AgRequestBuilder;
import io.agrest.RootResourceEntity;
import io.agrest.access.PathChecker;
import io.agrest.cayenne.cayenne.main.E1;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.processor.CayenneProcessor;
import io.agrest.cayenne.unit.main.MainNoDbTest;
import io.agrest.exp.AgExpressionException;
import io.agrest.id.AgObjectId;
import io.agrest.meta.AgSchema;
import io.agrest.protocol.Direction;
import io.agrest.protocol.Exp;
import io.agrest.protocol.Sort;
import io.agrest.runtime.meta.RequestSchema;
import io.agrest.runtime.processor.select.SelectContext;
import java.util.Arrays;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CayenneQueryAssemblerTest
extends MainNoDbTest {
    @Test
    public void createRootQuery_Ordering() {
        RootResourceEntity<E1> entity = this.getResourceEntity(E1.class);
        entity.getOrderings().add(new Sort("name", Direction.asc));
        SelectContext c = new SelectContext(E1.class, new RequestSchema((AgSchema)Mockito.mock(AgSchema.class)), (AgRequestBuilder)Mockito.mock(AgRequestBuilder.class), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        c.setEntity(entity);
        ObjectSelect q1 = this.queryAssembler.createRootQuery(c);
        Assertions.assertEquals(Arrays.asList(E1.NAME.asc()), (Object)q1.getOrderings());
        entity.getOrderings().add(new Sort("name", Direction.desc));
        ObjectSelect q2 = this.queryAssembler.createRootQuery(c);
        Assertions.assertEquals(Arrays.asList(E1.NAME.asc(), E1.NAME.desc()), (Object)q2.getOrderings());
    }

    @Test
    public void createRootQuery_Pagination() {
        RootResourceEntity entity = new RootResourceEntity(this.getAgEntity(E1.class));
        entity.setLimit(10);
        entity.setStart(0);
        SelectContext c = new SelectContext(E1.class, new RequestSchema((AgSchema)Mockito.mock(AgSchema.class)), (AgRequestBuilder)Mockito.mock(AgRequestBuilder.class), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        c.setEntity(entity);
        ObjectSelect q1 = this.queryAssembler.createRootQuery(c);
        Assertions.assertEquals((int)10, (int)q1.getPageSize(), (String)"Pagination in the query for paginated request is expected");
        Assertions.assertEquals((int)0, (int)q1.getOffset());
        Assertions.assertEquals((int)0, (int)q1.getLimit());
        entity.setLimit(0);
        entity.setStart(0);
        CayenneProcessor.getOrCreateRootEntity((RootResourceEntity)entity).setSelect(null);
        ObjectSelect q2 = this.queryAssembler.createRootQuery(c);
        Assertions.assertEquals((int)0, (int)q2.getPageSize());
        Assertions.assertEquals((int)0, (int)q2.getOffset());
        Assertions.assertEquals((int)0, (int)q2.getLimit());
        entity.setLimit(0);
        entity.setStart(5);
        ObjectSelect q3 = this.queryAssembler.createRootQuery(c);
        Assertions.assertEquals((int)0, (int)q3.getPageSize());
        Assertions.assertEquals((int)0, (int)q3.getOffset());
        Assertions.assertEquals((int)0, (int)q3.getLimit());
    }

    @Test
    public void createRootQuery_Qualifier() {
        RootResourceEntity<E1> entity = this.getResourceEntity(E1.class);
        SelectContext c = new SelectContext(E1.class, new RequestSchema((AgSchema)Mockito.mock(AgSchema.class)), (AgRequestBuilder)Mockito.mock(AgRequestBuilder.class), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        c.setEntity(entity);
        entity.andExp(Exp.parse((String)"name = 'X'"));
        ObjectSelect q1 = this.queryAssembler.createRootQuery(c);
        Assertions.assertEquals((Object)E1.NAME.eq((Object)"X"), (Object)q1.getWhere());
        entity.andExp(Exp.parse((String)"name in ('a', 'b')"));
        ObjectSelect q2 = this.queryAssembler.createRootQuery(c);
        Assertions.assertEquals((Object)E1.NAME.eq((Object)"X").andExp(E1.NAME.in((Object)"a", (Object[])new String[]{"b"})), (Object)q2.getWhere());
    }

    @Test
    public void createRootQuery_Qualifier_Exists() {
        RootResourceEntity<E3> entity = this.getResourceEntity(E3.class);
        SelectContext c = new SelectContext(E3.class, new RequestSchema((AgSchema)Mockito.mock(AgSchema.class)), (AgRequestBuilder)Mockito.mock(AgRequestBuilder.class), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        c.setEntity(entity);
        entity.andExp(Exp.parse((String)"exists e2"));
        ObjectSelect q1 = this.queryAssembler.createRootQuery(c);
        Expression expectedQ1 = ExpressionFactory.exists((FluentSelect)ObjectSelect.query(E3.class).column((Property)E3.E2));
        Assertions.assertEquals((Object)expectedQ1, (Object)q1.getWhere());
        entity.andExp(Exp.parse((String)"not exists e5"));
        ObjectSelect q2 = this.queryAssembler.createRootQuery(c);
        Assertions.assertEquals((Object)expectedQ1.andExp(ExpressionFactory.notExists((FluentSelect)ObjectSelect.query(E3.class).column((Property)E3.E5))), (Object)q2.getWhere());
    }

    @Test
    public void createRootQuery_Qualifier_Exists_Invalid_Condition() {
        RootResourceEntity<E3> entity = this.getResourceEntity(E3.class);
        SelectContext c = new SelectContext(E3.class, new RequestSchema((AgSchema)Mockito.mock(AgSchema.class)), (AgRequestBuilder)Mockito.mock(AgRequestBuilder.class), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        c.setEntity(entity);
        entity.andExp(Exp.exists((String)"name = 'test1'"));
        Assertions.assertThrows(AgExpressionException.class, () -> this.queryAssembler.createRootQuery(c));
    }

    @Test
    public void createRootQuery_ById() {
        SelectContext c = new SelectContext(E1.class, new RequestSchema((AgSchema)Mockito.mock(AgSchema.class)), (AgRequestBuilder)Mockito.mock(AgRequestBuilder.class), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        c.setId(AgObjectId.of((Object)1));
        c.setEntity(this.getResourceEntity(E1.class));
        ObjectSelect s1 = this.queryAssembler.createRootQuery(c);
        Assertions.assertNotNull((Object)s1);
        Assertions.assertSame(E1.class, (Object)s1.getEntityType());
    }

    @Test
    public void createRootQuery_ById_WithQuery() {
        ObjectSelect select = ObjectSelect.query(E1.class);
        SelectContext c = new SelectContext(E1.class, new RequestSchema((AgSchema)Mockito.mock(AgSchema.class)), (AgRequestBuilder)Mockito.mock(AgRequestBuilder.class), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        c.setId(AgObjectId.of((Object)1));
        c.setEntity(this.getResourceEntity(E1.class));
        CayenneProcessor.getOrCreateRootEntity((RootResourceEntity)c.getEntity()).setSelect(select);
        ObjectSelect s2 = this.queryAssembler.createRootQuery(c);
        Assertions.assertNotNull((Object)s2);
        Assertions.assertNotSame((Object)select, (Object)s2);
        Assertions.assertSame(E1.class, (Object)s2.getEntityType());
    }
}

