/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.path;

import io.agrest.AgException;
import io.agrest.cayenne.path.EntityPathCache;
import io.agrest.cayenne.path.PathDescriptor;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EntityPathCacheTest {
    private ObjEntity x;

    @BeforeEach
    public void setUp() {
        DataMap map = new DataMap();
        DbEntity dy = new DbEntity("Y");
        dy.addAttribute(new DbAttribute("pk1", 4, dy));
        dy.getAttribute("pk1").setPrimaryKey(true);
        map.addDbEntity(dy);
        ObjEntity y = new ObjEntity("Y");
        y.setDbEntityName("Y");
        y.setClassName("test.Y");
        y.addAttribute((Attribute)new ObjAttribute("name", "java.lang.String", this.x));
        map.addObjEntity(y);
        DbEntity dx = new DbEntity("X");
        dx.addAttribute(new DbAttribute("pkx1", 12, dy));
        dx.getAttribute("pkx1").setPrimaryKey(true);
        map.addDbEntity(dx);
        ObjEntity x = new ObjEntity("X");
        x.setDbEntityName("X");
        x.addAttribute((Attribute)new ObjAttribute("name", "java.lang.String", x));
        x.addRelationship((Relationship)new ObjRelationship("y"));
        x.getRelationship("y").setTargetEntityName("Y");
        map.addObjEntity(x);
        this.x = x;
    }

    @Test
    public void getOrCreate_Attribute() {
        EntityPathCache cache = new EntityPathCache(this.x);
        PathDescriptor pd = cache.getOrCreate("name");
        Assertions.assertNotNull((Object)pd);
        Assertions.assertTrue((boolean)pd.isAttributeOrId());
        Assertions.assertEquals((Object)"java.lang.String", (Object)pd.getType());
        Assertions.assertEquals((Object)"name", (Object)pd.getPathExp().getPath());
        Assertions.assertSame((Object)pd, (Object)cache.getOrCreate("name"));
    }

    @Test
    public void getOrCreate_Relationship() {
        EntityPathCache cache = new EntityPathCache(this.x);
        PathDescriptor pd = cache.getOrCreate("y");
        Assertions.assertNotNull((Object)pd);
        Assertions.assertFalse((boolean)pd.isAttributeOrId());
        Assertions.assertEquals((Object)"test.Y", (Object)pd.getType());
        Assertions.assertEquals((Object)"y", (Object)pd.getPathExp().getPath());
        Assertions.assertSame((Object)pd, (Object)cache.getOrCreate("y"));
    }

    @Test
    public void getOrCreate_RelatedAttribute() {
        EntityPathCache cache = new EntityPathCache(this.x);
        PathDescriptor pd = cache.getOrCreate("y.name");
        Assertions.assertNotNull((Object)pd);
        Assertions.assertTrue((boolean)pd.isAttributeOrId());
        Assertions.assertEquals((Object)"java.lang.String", (Object)pd.getType());
        Assertions.assertEquals((Object)"y.name", (Object)pd.getPathExp().getPath());
        Assertions.assertSame((Object)pd, (Object)cache.getOrCreate("y.name"));
    }

    @Test
    public void tesGetOrCreate_BadPath() {
        EntityPathCache cache = new EntityPathCache(this.x);
        Assertions.assertThrows(AgException.class, () -> cache.getOrCreate("y.xyz"));
    }

    @Test
    public void getOrCreate_OuterRelatedAttribute() {
        EntityPathCache cache = new EntityPathCache(this.x);
        PathDescriptor pd = cache.getOrCreate("y+.name");
        Assertions.assertNotNull((Object)pd);
        Assertions.assertTrue((boolean)pd.isAttributeOrId());
        Assertions.assertEquals((Object)"java.lang.String", (Object)pd.getType());
        Assertions.assertEquals((Object)"y+.name", (Object)pd.getPathExp().getPath());
        Assertions.assertSame((Object)pd, (Object)cache.getOrCreate("y+.name"));
        Assertions.assertNotSame((Object)pd, (Object)cache.getOrCreate("y.name"));
    }
}

