/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.exp;

import io.agrest.AgException;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.exp.ICayenneExpPostProcessor;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.bootique.junit5.BQTestTool;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTExists;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.parser.ASTSubquery;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ICayenneExpPostProcessorIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = ICayenneExpPostProcessorIT.tester(new Class[0]).build();
    ICayenneExpPostProcessor p = (ICayenneExpPostProcessor)tester.runtime().service(ICayenneExpPostProcessor.class);

    @Test
    void process() {
        Expression e0 = ExpressionFactory.exp((String)"name = 'a'", (Object[])new Object[0]);
        Expression e1 = this.p.process("E2", e0);
        Assertions.assertEquals((Object)e0, (Object)e1);
    }

    @Test
    void id() {
        Expression e0 = ExpressionFactory.exp((String)"id", (Object[])new Object[0]);
        Expression e1 = this.p.process("E2", e0);
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"db:id_", (Object[])new Object[0]), (Object)e1);
    }

    @Test
    void idEq() {
        Expression e0 = ExpressionFactory.exp((String)"id = 4", (Object[])new Object[0]);
        Expression e1 = this.p.process("E2", e0);
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"db:id_ = 4", (Object[])new Object[0]), (Object)e1);
    }

    @Test
    void toOne() {
        Expression e0 = ExpressionFactory.exp((String)"e2", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        Assertions.assertEquals((Object)e0, (Object)e1);
    }

    @Test
    void toOneEq() {
        Expression e0 = ExpressionFactory.exp((String)"e2 = 2", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        Assertions.assertEquals((Object)e0, (Object)e1);
    }

    @Test
    void relChain() {
        Expression e0 = ExpressionFactory.exp((String)"e2.e3s", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        Assertions.assertEquals((Object)e0, (Object)e1);
    }

    @Test
    void relAlias() {
        Expression e0 = ExpressionFactory.exp((String)"e2#alias1", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        ICayenneExpPostProcessorIT.assertEqualsPathAliasAware(e0, e1);
    }

    @Test
    void relChainAlias() {
        Expression e0 = ExpressionFactory.exp((String)"e2#alias1.e3s", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        ICayenneExpPostProcessorIT.assertEqualsPathAliasAware(e0, e1);
    }

    @Test
    void relChainEndAlias() {
        Expression e0 = ExpressionFactory.exp((String)"e2.e3s#alias1", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        ICayenneExpPostProcessorIT.assertEqualsPathAliasAware(e0, e1);
    }

    @Test
    void relChainEndingWithAttribute() {
        Expression e0 = ExpressionFactory.exp((String)"e2.e3s.name", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        ICayenneExpPostProcessorIT.assertEqualsPathAliasAware(e0, e1);
    }

    @Test
    void relChainAliasEndingWithAttribute() {
        Expression e0 = ExpressionFactory.exp((String)"e2#alias1.e3s.name", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        ICayenneExpPostProcessorIT.assertEqualsPathAliasAware(e0, e1);
    }

    @Test
    void relChainAliasEndingWithAttributeExpression() {
        Expression e0 = ExpressionFactory.exp((String)"e2#alias1.e3s.name = 'a' and e2#alias2.e3s.name = 'b'", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        ICayenneExpPostProcessorIT.assertEqualsPathAliasAware(e0, e1);
    }

    @Test
    void relChainId() {
        Expression e0 = ExpressionFactory.exp((String)"e2.e3s.id = 1", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        Assertions.assertEquals((Object)e0, (Object)e1);
    }

    @Test
    void relChainAliasId() {
        Expression e0 = ExpressionFactory.exp((String)"e2#alias1.e3s.id = 1 and e2#alias2.e3s.id = 2", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        ICayenneExpPostProcessorIT.assertEqualsPathAliasAware(e0, e1);
    }

    @Test
    void toOneId() {
        Expression e0 = ExpressionFactory.exp((String)"e2.id", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"e2", (Object[])new Object[0]), (Object)e1);
    }

    @Test
    void toOneIdEq() {
        Expression e0 = ExpressionFactory.exp((String)"e2.id = 2", (Object[])new Object[0]);
        Expression e1 = this.p.process("E3", e0);
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"e2 = 2", (Object[])new Object[0]), (Object)e1);
    }

    @Test
    void existsAtRoot() {
        ASTExists e0 = new ASTExists(null);
        e0.jjtAddChild((Node)((SimpleNode)E3.E2.dot(E2.NAME).getExpression()), 0);
        Expression e1 = this.p.process("E3", (Expression)e0);
        Expression subqueryWhere = E2.NAME.isNotNull().andExp(ExpressionFactory.matchDbExp((String)"id_", (Object)ExpressionFactory.enclosingObjectExp((Expression)ExpressionFactory.dbPathExp((String)"e2_id"))));
        Expression expected = ExpressionFactory.exists((FluentSelect)ObjectSelect.columnQuery(E2.class, (Property)E2.NAME).where(subqueryWhere));
        Assertions.assertEquals((Object)expected, (Object)e1);
        Object operand = e1.getOperand(0);
        Assertions.assertInstanceOf(ASTSubquery.class, (Object)operand);
        TranslatableQueryWrapper query = ((ASTSubquery)operand).getQuery();
        Assertions.assertEquals((Object)subqueryWhere, (Object)query.getQualifier());
    }

    @Test
    void existsAtChild() {
        ASTExists exists = new ASTExists(null);
        exists.jjtAddChild((Node)((SimpleNode)E3.E2.dot(E2.NAME).getExpression()), 0);
        Expression e0 = ExpressionFactory.or((Expression[])new Expression[]{exists, E3.PHONE_NUMBER.contains("123")});
        Expression e1 = this.p.process("E3", e0);
        Expression subqueryWhere = E2.NAME.isNotNull().andExp(ExpressionFactory.matchDbExp((String)"id_", (Object)ExpressionFactory.enclosingObjectExp((Expression)ExpressionFactory.dbPathExp((String)"e2_id"))));
        Expression expected = ExpressionFactory.or((Expression[])new Expression[]{ExpressionFactory.exists((FluentSelect)ObjectSelect.columnQuery(E2.class, (Property)E2.NAME).where(subqueryWhere)), E3.PHONE_NUMBER.contains("123")});
        Assertions.assertEquals((Object)expected, (Object)e1);
        Object operand = e1.getOperand(0);
        Assertions.assertInstanceOf(ASTExists.class, (Object)operand);
        Object queryOperand = ((ASTExists)operand).getOperand(0);
        Assertions.assertInstanceOf(ASTSubquery.class, (Object)queryOperand);
        TranslatableQueryWrapper query = ((ASTSubquery)queryOperand).getQuery();
        Assertions.assertEquals((Object)subqueryWhere, (Object)query.getQualifier());
    }

    @Test
    void invalidPath() {
        Assertions.assertThrows(AgException.class, () -> this.p.process("E2", ExpressionFactory.exp((String)"a.b.c = 2", (Object[])new Object[0])));
    }

    static void assertEqualsPathAliasAware(Expression expected, Expression actual) {
        Assertions.assertEquals((Object)expected, (Object)actual);
        if (expected instanceof ASTPath && actual instanceof ASTPath) {
            ASTPath expectedPath = (ASTPath)expected;
            ASTPath actualPath = (ASTPath)actual;
            Assertions.assertEquals((Object)expectedPath.getPathAliases(), (Object)actualPath.getPathAliases(), (String)"Expressions have different path aliases");
        }
        SimpleNode expectedNode = (SimpleNode)expected;
        SimpleNode actualNode = (SimpleNode)actual;
        for (int i = 0; i < expectedNode.jjtGetNumChildren(); ++i) {
            ICayenneExpPostProcessorIT.assertEqualsPathAliasAware((Expression)expectedNode.jjtGetChild(i), (Expression)actualNode.jjtGetChild(i));
        }
    }
}

