/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.exp;

import io.agrest.cayenne.exp.CayenneExpParser;
import io.agrest.protocol.Exp;
import java.time.LocalDate;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CayenneExpParserTest {
    static final CayenneExpParser parser = new CayenneExpParser();

    @Test
    public void parseNamedParams() {
        Expression e = parser.parse(Exp.parse((String)"a = $a").namedParams(Map.of("a", "x")));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a = 'x'", (Object[])new Object[0]), (Object)e);
    }

    @Test
    public void parsePathAliases() {
        Expression e = parser.parse(Exp.parse((String)"a.b.c#p1.d#p2"));
        Expression expected = ExpressionFactory.exp((String)"a.b.c#p1.d#p2", (Object[])new Object[0]);
        Assertions.assertEquals((Object)expected, (Object)e);
        Assertions.assertEquals((Object)expected.getPathAliases(), (Object)e.getPathAliases());
    }

    @Test
    public void parsePositionalParams() {
        Expression e = parser.parse(Exp.parse((String)"a = $a").positionalParams(new Object[]{"x"}));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a = 'x'", (Object[])new Object[0]), (Object)e);
    }

    @Test
    public void parsePositionalParams_NullAndParam() {
        Exp agExp = Exp.parse((String)"a = null or a.b = $b").positionalParams(new Object[]{"B"});
        Expression e = parser.parse(agExp);
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a = null or a.b = 'B'", (Object[])new Object[0]), (Object)e);
    }

    @Test
    public void parseEqual() {
        Expression e = parser.parse(Exp.equal((String)"a", (Object)5));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a = 5", (Object[])new Object[0]), (Object)e);
    }

    @Test
    public void parseGreaterEqualNegative() {
        Expression e = parser.parse(Exp.parse((String)"a >= -5"));
        Assertions.assertEquals((Object)ExpressionFactory.greaterOrEqualExp((String)"a", (Object)-5), (Object)e);
    }

    @Test
    public void parseNotEqual() {
        Expression e = parser.parse(Exp.notEqual((String)"a", (Object)5));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a != 5", (Object[])new Object[0]), (Object)e);
    }

    @Test
    public void parseEqualDate() {
        LocalDate d = LocalDate.of(1999, 8, 7);
        Expression e = parser.parse(Exp.equal((String)"a", (Object)d));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a = $a", (Object[])new Object[0]).paramsArray(new Object[]{d}), (Object)e);
    }

    @Test
    public void parseEqual_Object() {
        Object o = new Object();
        Expression e = parser.parse(Exp.equal((String)"a", (Object)o));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a = $a", (Object[])new Object[0]).paramsArray(new Object[]{o}), (Object)e);
    }

    @Test
    public void parseIn() {
        Expression e1 = parser.parse(Exp.in((String)"a", (Object[])new Object[]{5, 6, 7}));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a in (5, 6, 7)", (Object[])new Object[0]), (Object)e1);
        Expression e2 = parser.parse(Exp.in((String)"a", (Object[])new Object[]{"x", "y", "z"}));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a in ('x','y','z')", (Object[])new Object[0]), (Object)e2);
        Expression e3 = parser.parse(Exp.in((String)"a", (Object[])new Object[]{5, 6, 7}));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a in (5, 6, 7)", (Object[])new Object[0]), (Object)e3);
        Expression e4 = parser.parse(Exp.in((String)"a", (Object[])new Object[0]));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"false", (Object[])new Object[0]), (Object)e4);
    }

    @Test
    public void parseNotIn() {
        Expression e1 = parser.parse(Exp.notIn((String)"a", (Object[])new Object[]{5, 6, 7}));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a not in (5, 6, 7)", (Object[])new Object[0]), (Object)e1);
        Expression e2 = parser.parse(Exp.notIn((String)"a", (Object[])new Object[]{"x", "y", "z"}));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a not in ('x','y','z')", (Object[])new Object[0]), (Object)e2);
        Expression e3 = parser.parse(Exp.notIn((String)"a", (Object[])new Object[]{5, 6, 7}));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"a not in (5, 6, 7)", (Object[])new Object[0]), (Object)e3);
        Expression e4 = parser.parse(Exp.notIn((String)"a", (Object[])new Object[0]));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"true", (Object[])new Object[0]), (Object)e4);
    }

    @Test
    public void parseEqual_DbPath() {
        Expression e = parser.parse(Exp.equal((String)"db:a", (Object)5));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"db:a = 5", (Object[])new Object[0]), (Object)e);
    }

    @Test
    public void parseEqual_DbPathAlias() {
        Expression e = parser.parse(Exp.equal((String)"db:a#alias1", (Object)5));
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"db:a#alias1 = 5", (Object[])new Object[0]), (Object)e);
    }

    @Test
    public void parseCompositeCondition() {
        Exp e0 = Exp.parse((String)"a = 'b'");
        Exp e1 = Exp.parse((String)"b = $a").namedParams(Map.of("a", "x"));
        Exp e2 = Exp.parse((String)"c = $a").positionalParams(new Object[]{"y"});
        Exp e3 = Exp.parse((String)"d = 'z'").and(e0).or(e1).and(e2);
        Expression e = parser.parse(e3);
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"(((d = 'z') and (a = 'b')) or (b = 'x')) and (c = 'y')", (Object[])new Object[0]), (Object)e);
    }

    @Test
    public void parseComposite_DifferentOrder() {
        Exp e1 = Exp.parse((String)"id = $id").positionalParams(new Object[]{1});
        Exp e2 = Exp.in((String)"otherId", (Object[])new Object[]{1, 2, 3});
        Exp composite1 = e1.and(e2);
        Exp composite2 = e2.and(e1);
        Expression cayenneComposite1 = parser.parse(composite1);
        Expression cayenneComposite2 = parser.parse(composite2);
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"(id = 1) and (otherId in (1, 2, 3))", (Object[])new Object[0]), (Object)cayenneComposite1);
        Assertions.assertEquals((Object)ExpressionFactory.exp((String)"(otherId in (1, 2, 3)) and (id = 1)", (Object[])new Object[0]), (Object)cayenneComposite2);
    }
}

