/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.encoder;

import io.agrest.DataResponse;
import io.agrest.ResourceEntity;
import io.agrest.RootResourceEntity;
import io.agrest.ToManyResourceEntity;
import io.agrest.cayenne.cayenne.main.E1;
import io.agrest.cayenne.cayenne.main.E19;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.processor.CayenneProcessor;
import io.agrest.cayenne.unit.main.MainNoDbTest;
import io.agrest.converter.valuestring.ValueStringConverters;
import io.agrest.converter.valuestring.ValueStringConvertersProvider;
import io.agrest.encoder.Encoder;
import io.agrest.encoder.ValueEncodersProvider;
import io.agrest.id.AgObjectId;
import io.agrest.processor.ProcessingContext;
import io.agrest.runtime.encoder.EncodablePropertyFactory;
import io.agrest.runtime.encoder.EncoderFactory;
import io.agrest.runtime.encoder.IEncodablePropertyFactory;
import io.agrest.runtime.jackson.IJacksonService;
import io.agrest.runtime.jackson.JacksonService;
import io.agrest.runtime.semantics.IRelationshipMapper;
import io.agrest.runtime.semantics.RelationshipMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class EncoderFactoryTest
extends MainNoDbTest {
    private static final IJacksonService jacksonService = JacksonService.create();
    private EncoderFactory encoderFactory;

    @BeforeEach
    public void before() {
        ValueStringConverters converters = new ValueStringConvertersProvider(Collections.emptyMap()).get();
        EncodablePropertyFactory epf = new EncodablePropertyFactory(new ValueEncodersProvider(converters, Collections.emptyMap()).get());
        this.encoderFactory = new EncoderFactory((IEncodablePropertyFactory)epf, converters, (IRelationshipMapper)new RelationshipMapper());
    }

    @Test
    public void getRootEncoder_ExcludedAttributes() {
        RootResourceEntity<E1> descriptor = this.getResourceEntity(E1.class);
        descriptor.includeId();
        E1 e1 = new E1();
        e1.setObjectId(ObjectId.of((String)"E1", (String)"id", (Object)777));
        e1.setName("XYZ");
        e1.setAge(30);
        e1.setDescription("test");
        Assertions.assertEquals((Object)"{\"data\":[{\"id\":777}],\"total\":1}", (Object)this.toJson((Object)e1, (ResourceEntity<?>)descriptor));
    }

    @Test
    public void getRootEncoder_ExcludedRelationshipAttributes() {
        RootResourceEntity<E2> re = this.getResourceEntity(E2.class);
        re.includeId();
        CayenneProcessor.getOrCreateRootEntity(re);
        ToManyResourceEntity<E3> reE3 = this.getToManyChildEntity(E3.class, (ResourceEntity<?>)re, E2.E3S.getName());
        reE3.includeId();
        CayenneProcessor.getOrCreateRelatedEntity(reE3);
        reE3.ensureAttribute("name", false);
        re.ensureChild("e3s", (e, r) -> reE3);
        re.getBaseProjection().ensureRelationship("e3s");
        ObjectContext context = this.mockCayennePersister.newContext();
        E2 e2 = new E2();
        e2.setObjectId(ObjectId.of((String)"E2", (String)"id_", (Object)7));
        e2.setName("XYZ");
        e2.setAddress("bla bla street");
        context.registerNewObject((Object)e2);
        E3 e31 = new E3();
        e31.setObjectId(ObjectId.of((String)"E3", (String)"id_", (Object)5));
        e31.setName("31");
        e31.setPhoneNumber("+12345678");
        context.registerNewObject((Object)e31);
        e2.addToE3s(e31);
        E3 e32 = new E3();
        e32.setObjectId(ObjectId.of((String)"E3", (String)"id_", (Object)6));
        e32.setName("32");
        e31.setPhoneNumber("+87654321");
        context.registerNewObject((Object)e32);
        e2.addToE3s(e32);
        re.setData(List.of(e2));
        reE3.addData(AgObjectId.of((Object)7), (Object)e31);
        reE3.addData(AgObjectId.of((Object)7), (Object)e32);
        Assertions.assertEquals((Object)"{\"data\":[{\"id\":7,\"e3s\":[{\"id\":5,\"name\":\"31\"},{\"id\":6,\"name\":\"32\"}]}],\"total\":1}", (Object)this.toJson((Object)e2, (ResourceEntity<?>)re));
    }

    @Test
    public void encoder_BinaryAttribute() {
        RootResourceEntity<E19> descriptor = this.getResourceEntity(E19.class);
        descriptor.includeId();
        descriptor.ensureAttribute("guid", false);
        E19 e19 = new E19();
        e19.setObjectId(ObjectId.of((String)"E19", (String)"id", (Object)1));
        e19.setGuid("abcdefghjklmnopr".getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"{\"data\":[{\"id\":1,\"guid\":\"YWJjZGVmZ2hqa2xtbm9wcg==\"}],\"total\":1}", (Object)this.toJson((Object)e19, (ResourceEntity<?>)descriptor));
    }

    private String toJson(Object object, ResourceEntity<?> resourceEntity) {
        Encoder encoder = this.encoderFactory.encoder(resourceEntity, (ProcessingContext)Mockito.mock(ProcessingContext.class));
        return this.toJson(encoder, DataResponse.of((int)200, List.of(object)).build());
    }

    private String toJson(Encoder encoder, Object value) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            jacksonService.outputJson(g -> encoder.encode(null, value, false, g), (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException("Encoding error: " + e.getMessage());
        }
        return out.toString();
    }
}

