/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.compiler;

import io.agrest.cayenne.cayenne.inheritance.Ie1Sub1;
import io.agrest.cayenne.cayenne.inheritance.Ie1Sub1Sub1;
import io.agrest.cayenne.cayenne.inheritance.Ie1Sub2;
import io.agrest.cayenne.cayenne.inheritance.Ie1Super;
import io.agrest.cayenne.cayenne.inheritance.Ie2;
import io.agrest.cayenne.unit.inheritance.InheritanceNoDbTest;
import io.agrest.meta.AgAttribute;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgRelationship;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CayenneCompiler_InheritanceIT
extends InheritanceNoDbTest {
    @Test
    public void getAttributes_Sub() {
        AgEntity<Ie1Sub2> ieSub2 = this.getAgEntity(Ie1Sub2.class);
        String as = ieSub2.getAttributes().stream().map(AgAttribute::getName).sorted().collect(Collectors.joining(","));
        Assertions.assertEquals((Object)"a0,a2,type", (Object)as, (String)"Must include own and inherited attributes");
    }

    @Test
    public void getAttributes_SubSub() {
        AgEntity<Ie1Sub1Sub1> ieSub1Sub1 = this.getAgEntity(Ie1Sub1Sub1.class);
        String as = ieSub1Sub1.getAttributes().stream().map(AgAttribute::getName).sorted().collect(Collectors.joining(","));
        Assertions.assertEquals((Object)"a0,a1,a3,type", (Object)as, (String)"Must include own and inherited attributes");
    }

    @Test
    public void getAttributes_Super() {
        String as = this.getAgEntity(Ie1Super.class).getAttributes().stream().map(AgAttribute::getName).sorted().collect(Collectors.joining(","));
        Assertions.assertEquals((Object)"a0,type", (Object)as, (String)"Must include own, inherited and subclass attributes");
    }

    @Test
    public void getRelationships_Sub() {
        AgEntity<Ie1Sub1> ieSub1 = this.getAgEntity(Ie1Sub1.class);
        String rs = ieSub1.getRelationships().stream().map(AgRelationship::getName).sorted().collect(Collectors.joining(","));
        Assertions.assertEquals((Object)"ie2,ie3s", (Object)rs, (String)"Must include own and inherited relationships");
    }

    @Test
    public void getSubEntities_Super() {
        String es1 = this.getAgEntity(Ie1Super.class).getSubEntities().stream().map(AgEntity::getName).sorted().collect(Collectors.joining(","));
        Assertions.assertEquals((Object)"Ie1Sub1,Ie1Sub2", (Object)es1, (String)"Must include direct sub-entities");
        String es2 = this.getAgEntity(Ie1Sub1.class).getSubEntities().stream().map(AgEntity::getName).sorted().collect(Collectors.joining(","));
        Assertions.assertEquals((Object)"Ie1Sub1Sub1", (Object)es2, (String)"Must include direct sub-entities");
    }

    @Test
    public void getSubEntities_Sub() {
        Assertions.assertTrue((boolean)this.getAgEntity(Ie1Sub2.class).getSubEntities().isEmpty());
    }

    @Test
    public void getSubEntities_NoInheritance() {
        Assertions.assertTrue((boolean)this.getAgEntity(Ie2.class).getSubEntities().isEmpty());
    }
}

