/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.PUT;

import io.agrest.EntityUpdate;
import io.agrest.SimpleResponse;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import java.util.List;
import org.junit.jupiter.api.Test;

public class UpdateAuthorizerIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = UpdateAuthorizerIT.tester(Resource.class).entities(E2.class, E3.class, E4.class).agCustomizer(ab -> ab.entityOverlay(AgEntity.overlay(E2.class).updateAuthorizer((o, u) -> o.getName().equals(u.getAttributes().get("name"))))).build();

    @Test
    public void inStack_Allowed() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "a"}).values(new Object[]{2, "b"}).exec();
        tester.target("/e2_stack_authorizer").put("[{\"id\":2,\"name\":\"b\",\"address\":\"Bb\"},{\"id\":1,\"name\":\"a\",\"address\":\"Aa\"}]").wasOk();
        tester.e2().matcher().assertMatches(2);
        tester.e2().matcher().eq("name", (Object)"a").andEq("address", (Object)"Aa").assertOneMatch();
        tester.e2().matcher().eq("name", (Object)"b").andEq("address", (Object)"Bb").assertOneMatch();
    }

    @Test
    public void inStack_Blocked() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "a"}).values(new Object[]{2, "b"}).exec();
        tester.target("/e2_stack_authorizer").put("[{\"id\":2,\"name\":\"b\",\"address\":\"Bb\"},{\"id\":1,\"name\":\"Aa\",\"address\":\"Aa\"}]").wasForbidden();
        tester.e2().matcher().assertMatches(2);
        tester.e2().matcher().eq("name", (Object)"a").andEq("address", null).assertOneMatch();
        tester.e2().matcher().eq("name", (Object)"b").andEq("address", null).assertOneMatch();
    }

    @Test
    public void inRequestAndStack_Allowed() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "a"}).values(new Object[]{2, "b"}).exec();
        tester.target("/e2_request_and_stack_authorizer/not_this").put("[{\"id\":2,\"name\":\"b\",\"address\":\"Bb\"},{\"id\":1,\"name\":\"a\",\"address\":\"Aa\"}]").wasOk();
        tester.e2().matcher().assertMatches(2);
        tester.e2().matcher().eq("name", (Object)"a").andEq("address", (Object)"Aa").assertOneMatch();
        tester.e2().matcher().eq("name", (Object)"b").andEq("address", (Object)"Bb").assertOneMatch();
    }

    @Test
    public void inRequestAndStack_Blocked() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "a"}).values(new Object[]{2, "b"}).exec();
        tester.target("/e2_request_and_stack_authorizer/b").put("[{\"id\":2,\"name\":\"b\",\"address\":\"Bb\"},{\"id\":1,\"name\":\"a\",\"address\":\"Aa\"}]").wasForbidden();
        tester.e2().matcher().assertMatches(2);
        tester.e2().matcher().eq("name", (Object)"a").andEq("address", null).assertOneMatch();
        tester.e2().matcher().eq("name", (Object)"b").andEq("address", null).assertOneMatch();
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @PUT
        @Path(value="e2_stack_authorizer")
        public SimpleResponse putE2StackFilter(List<EntityUpdate<E2>> updates) {
            return AgJaxrs.createOrUpdate(E2.class, (Configuration)this.config).sync(updates);
        }

        @PUT
        @Path(value="e2_request_and_stack_authorizer/{name}")
        public SimpleResponse putE2RequestAndStackFilter(@PathParam(value="name") String name, List<EntityUpdate<E2>> updates) {
            return AgJaxrs.createOrUpdate(E2.class, (Configuration)this.config).updateAuthorizer(E2.class, (o, u) -> !name.equals(u.getAttributes().get("name"))).sync(updates);
        }
    }
}

