/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.PUT;

import io.agrest.DataResponse;
import io.agrest.UpdateStage;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.runtime.processor.update.UpdateContext;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StagesIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = StagesIT.tester(Resource.class).entities(E3.class).build();

    @BeforeEach
    public void resetCallbacks() {
        Resource.START_CALLED = false;
        Resource.PARSE_REQUEST_CALLED = false;
        Resource.CREATE_ENTITY_CALLED = false;
        Resource.APPLY_SERVER_PARAMS_CALLED = false;
        Resource.MAP_CHANGES_CALLED = false;
        Resource.MERGE_CHANGES_CALLED = false;
        Resource.COMMIT_CALLED = false;
        Resource.FILL_RESPONSE_CALLED = false;
    }

    @Test
    public void toOne() {
        tester.e3().insertColumns(new String[]{"id_", "name"}).values(new Object[]{3, "z"}).values(new Object[]{4, "a"}).exec();
        tester.target("/e3/callbackstage").put("[{\"id\":3,\"name\":\"x\"}]").wasOk().bodyEquals(1L, new String[]{"{\"id\":3,\"name\":\"x\",\"phoneNumber\":null}"});
        tester.e3().matcher().eq("id_", (Object)3).andEq("name", (Object)"x").assertOneMatch();
        tester.e3().matcher().eq("id_", (Object)4).assertNoMatches();
        Assertions.assertTrue((boolean)Resource.START_CALLED);
        Assertions.assertTrue((boolean)Resource.PARSE_REQUEST_CALLED);
        Assertions.assertTrue((boolean)Resource.CREATE_ENTITY_CALLED);
        Assertions.assertTrue((boolean)Resource.APPLY_SERVER_PARAMS_CALLED);
        Assertions.assertTrue((boolean)Resource.MERGE_CHANGES_CALLED);
        Assertions.assertTrue((boolean)Resource.COMMIT_CALLED);
        Assertions.assertTrue((boolean)Resource.FILL_RESPONSE_CALLED);
    }

    @Path(value="")
    public static class Resource {
        public static boolean START_CALLED;
        public static boolean PARSE_REQUEST_CALLED;
        public static boolean CREATE_ENTITY_CALLED;
        public static boolean APPLY_SERVER_PARAMS_CALLED;
        public static boolean MAP_CHANGES_CALLED;
        public static boolean MERGE_CHANGES_CALLED;
        public static boolean COMMIT_CALLED;
        public static boolean FILL_RESPONSE_CALLED;
        @Context
        private Configuration config;

        @PUT
        @Path(value="e3/callbackstage")
        public DataResponse<E3> syncWithCallbackStage(@Context UriInfo uriInfo, String requestBody) {
            return AgJaxrs.idempotentFullSync(E3.class, (Configuration)this.config).stage(UpdateStage.START, this::onStart).stage(UpdateStage.PARSE_REQUEST, this::onParseRequest).stage(UpdateStage.CREATE_ENTITY, this::onCreateEntity).stage(UpdateStage.APPLY_SERVER_PARAMS, this::onApplyServerParams).stage(UpdateStage.MAP_CHANGES, this::onMapChanges).stage(UpdateStage.MERGE_CHANGES, this::onMergeChanges).stage(UpdateStage.COMMIT, this::onCommit).stage(UpdateStage.FILL_RESPONSE, this::onFillResponse).clientParams((Map)uriInfo.getQueryParameters()).syncAndSelect(requestBody);
        }

        private void onStart(UpdateContext<E3> context) {
            Assertions.assertFalse((boolean)START_CALLED);
            Assertions.assertFalse((boolean)PARSE_REQUEST_CALLED);
            Assertions.assertFalse((boolean)CREATE_ENTITY_CALLED);
            Assertions.assertFalse((boolean)APPLY_SERVER_PARAMS_CALLED);
            Assertions.assertFalse((boolean)MAP_CHANGES_CALLED);
            Assertions.assertFalse((boolean)MERGE_CHANGES_CALLED);
            Assertions.assertFalse((boolean)COMMIT_CALLED);
            Assertions.assertFalse((boolean)FILL_RESPONSE_CALLED);
            START_CALLED = true;
        }

        private void onParseRequest(UpdateContext<E3> context) {
            Assertions.assertTrue((boolean)START_CALLED);
            Assertions.assertFalse((boolean)PARSE_REQUEST_CALLED);
            Assertions.assertFalse((boolean)CREATE_ENTITY_CALLED);
            Assertions.assertFalse((boolean)APPLY_SERVER_PARAMS_CALLED);
            Assertions.assertFalse((boolean)MAP_CHANGES_CALLED);
            Assertions.assertFalse((boolean)MERGE_CHANGES_CALLED);
            Assertions.assertFalse((boolean)COMMIT_CALLED);
            Assertions.assertFalse((boolean)FILL_RESPONSE_CALLED);
            PARSE_REQUEST_CALLED = true;
        }

        private void onCreateEntity(UpdateContext<E3> context) {
            Assertions.assertTrue((boolean)START_CALLED);
            Assertions.assertTrue((boolean)PARSE_REQUEST_CALLED);
            Assertions.assertFalse((boolean)CREATE_ENTITY_CALLED);
            Assertions.assertFalse((boolean)APPLY_SERVER_PARAMS_CALLED);
            Assertions.assertFalse((boolean)MAP_CHANGES_CALLED);
            Assertions.assertFalse((boolean)MERGE_CHANGES_CALLED);
            Assertions.assertFalse((boolean)COMMIT_CALLED);
            Assertions.assertFalse((boolean)FILL_RESPONSE_CALLED);
            CREATE_ENTITY_CALLED = true;
        }

        private void onApplyServerParams(UpdateContext<E3> context) {
            Assertions.assertTrue((boolean)START_CALLED);
            Assertions.assertTrue((boolean)PARSE_REQUEST_CALLED);
            Assertions.assertTrue((boolean)CREATE_ENTITY_CALLED);
            Assertions.assertFalse((boolean)APPLY_SERVER_PARAMS_CALLED);
            Assertions.assertFalse((boolean)MAP_CHANGES_CALLED);
            Assertions.assertFalse((boolean)MERGE_CHANGES_CALLED);
            Assertions.assertFalse((boolean)COMMIT_CALLED);
            Assertions.assertFalse((boolean)FILL_RESPONSE_CALLED);
            APPLY_SERVER_PARAMS_CALLED = true;
        }

        private void onMapChanges(UpdateContext<E3> context) {
            Assertions.assertTrue((boolean)START_CALLED);
            Assertions.assertTrue((boolean)PARSE_REQUEST_CALLED);
            Assertions.assertTrue((boolean)CREATE_ENTITY_CALLED);
            Assertions.assertTrue((boolean)APPLY_SERVER_PARAMS_CALLED);
            Assertions.assertFalse((boolean)MAP_CHANGES_CALLED);
            Assertions.assertFalse((boolean)MERGE_CHANGES_CALLED);
            Assertions.assertFalse((boolean)COMMIT_CALLED);
            Assertions.assertFalse((boolean)FILL_RESPONSE_CALLED);
            MAP_CHANGES_CALLED = true;
        }

        private void onMergeChanges(UpdateContext<E3> context) {
            Assertions.assertTrue((boolean)START_CALLED);
            Assertions.assertTrue((boolean)PARSE_REQUEST_CALLED);
            Assertions.assertTrue((boolean)CREATE_ENTITY_CALLED);
            Assertions.assertTrue((boolean)APPLY_SERVER_PARAMS_CALLED);
            Assertions.assertTrue((boolean)MAP_CHANGES_CALLED);
            Assertions.assertFalse((boolean)MERGE_CHANGES_CALLED);
            Assertions.assertFalse((boolean)COMMIT_CALLED);
            Assertions.assertFalse((boolean)FILL_RESPONSE_CALLED);
            MERGE_CHANGES_CALLED = true;
        }

        private void onCommit(UpdateContext<E3> context) {
            Assertions.assertTrue((boolean)START_CALLED);
            Assertions.assertTrue((boolean)PARSE_REQUEST_CALLED);
            Assertions.assertTrue((boolean)CREATE_ENTITY_CALLED);
            Assertions.assertTrue((boolean)APPLY_SERVER_PARAMS_CALLED);
            Assertions.assertTrue((boolean)MAP_CHANGES_CALLED);
            Assertions.assertTrue((boolean)MERGE_CHANGES_CALLED);
            Assertions.assertFalse((boolean)COMMIT_CALLED);
            Assertions.assertFalse((boolean)FILL_RESPONSE_CALLED);
            COMMIT_CALLED = true;
        }

        private void onFillResponse(UpdateContext<E3> context) {
            Assertions.assertTrue((boolean)START_CALLED);
            Assertions.assertTrue((boolean)PARSE_REQUEST_CALLED);
            Assertions.assertTrue((boolean)CREATE_ENTITY_CALLED);
            Assertions.assertTrue((boolean)APPLY_SERVER_PARAMS_CALLED);
            Assertions.assertTrue((boolean)MAP_CHANGES_CALLED);
            Assertions.assertTrue((boolean)MERGE_CHANGES_CALLED);
            Assertions.assertTrue((boolean)COMMIT_CALLED);
            Assertions.assertFalse((boolean)FILL_RESPONSE_CALLED);
            FILL_RESPONSE_CALLED = true;
        }
    }
}

