/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.PUT;

import io.agrest.DataResponse;
import io.agrest.EntityUpdate;
import io.agrest.access.ReadFilter;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.Persistent;
import org.junit.jupiter.api.Test;

public class ReadFilter_OverlayIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = ReadFilter_OverlayIT.tester(Resource.class).entities(E2.class, E3.class, E4.class).agCustomizer(ab -> ab.entityOverlay(AgEntity.overlay(E2.class).readFilter(ReadFilter_OverlayIT.evenFilter())).entityOverlay(AgEntity.overlay(E3.class).readFilter(ReadFilter_OverlayIT.oddFilter())).entityOverlay(AgEntity.overlay(E4.class).readFilter(ReadFilter_OverlayIT.evenFilter()))).build();

    static <T extends DataObject> ReadFilter<T> evenFilter() {
        return o -> Cayenne.intPKForObject((Persistent)o) % 2 == 0;
    }

    static <T extends DataObject> ReadFilter<T> oddFilter() {
        return o -> Cayenne.intPKForObject((Persistent)o) % 2 != 0;
    }

    @Test
    public void inStack() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "a"}).values(new Object[]{2, "b"}).values(new Object[]{4, "c"}).exec();
        tester.target("/e2_stack_filter").queryParam("include", new Object[]{"id", "name"}).put("[{\"id\":2,\"name\":\"Bb\"},{\"id\":1,\"name\":\"Aa\"},{\"id\":4,\"name\":\"Cc\"}]").wasOk().bodyEquals(2L, new String[]{"{\"id\":2,\"name\":\"Bb\"}", "{\"id\":4,\"name\":\"Cc\"}"});
        tester.e2().matcher().assertMatches(3);
        tester.e2().matcher().eq("id_", (Object)1).andEq("name", (Object)"Aa").assertOneMatch();
        tester.e2().matcher().eq("id_", (Object)2).andEq("name", (Object)"Bb").assertOneMatch();
        tester.e2().matcher().eq("id_", (Object)4).andEq("name", (Object)"Cc").assertOneMatch();
    }

    @Test
    public void inStack_Related() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "a"}).values(new Object[]{2, "b"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "e2_id"}).values(new Object[]{11, 1}).values(new Object[]{21, 2}).values(new Object[]{22, 2}).exec();
        tester.target("/e2_stack_filter").queryParam("include", new Object[]{"id", "e3s.id"}).queryParam("sort", new Object[]{"id"}).put("[{\"id\":2,\"name\":\"Bb\"},{\"id\":1,\"name\":\"Aa\"}]").wasOk().bodyEquals(1L, new String[]{"{\"id\":2,\"e3s\":[{\"id\":21}]}"});
    }

    @Test
    public void inStackAndRequest() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "a"}).values(new Object[]{2, "b"}).values(new Object[]{4, "c"}).exec();
        tester.target("/e2_request_and_stack_filter/Bb").queryParam("include", new Object[]{"id", "name"}).put("[{\"id\":2,\"name\":\"Bb\"},{\"id\":1,\"name\":\"Aa\"},{\"id\":4,\"name\":\"Cc\"}]").wasOk().bodyEquals(1L, new String[]{"{\"id\":2,\"name\":\"Bb\"}"});
        tester.e2().matcher().assertMatches(3);
        tester.e2().matcher().eq("id_", (Object)1).andEq("name", (Object)"Aa").assertOneMatch();
        tester.e2().matcher().eq("id_", (Object)2).andEq("name", (Object)"Bb").assertOneMatch();
        tester.e2().matcher().eq("id_", (Object)4).andEq("name", (Object)"Cc").assertOneMatch();
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @PUT
        @Path(value="e2_stack_filter")
        public DataResponse<E2> putE2StackFilter(@Context UriInfo uriInfo, List<EntityUpdate<E2>> updates) {
            return AgJaxrs.createOrUpdate(E2.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).syncAndSelect(updates);
        }

        @PUT
        @Path(value="e2_request_and_stack_filter/{name}")
        public DataResponse<E2> putE2RequestAndStackFilter(@Context UriInfo uriInfo, @PathParam(value="name") String name, List<EntityUpdate<E2>> updates) {
            return AgJaxrs.createOrUpdate(E2.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).readableFilter(E2.class, e2 -> name.equals(e2.getName())).syncAndSelect(updates);
        }
    }
}

