/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.PUT;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E5;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class ObjectIncludeIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = ObjectIncludeIT.tester(Resource.class).entitiesAndDependencies(E2.class, E3.class, E5.class).build();

    @Test
    public void overlap() {
        tester.e5().insertColumns(new String[]{"id", "name", "date"}).values(new Object[]{45, "T", "2013-01-03"}).exec();
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{8, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id", "e5_id"}).values(new Object[]{3, "zzz", 8, 45}).exec();
        tester.target("/e3/3").queryParam("include", new Object[]{"e2", "e2.id", "e5.id", "e5"}).put("{\"id\":3}").wasOk().bodyEquals(1L, new String[]{"{\"id\":3,\"e2\":{\"id\":8},\"e5\":{\"id\":45},\"name\":\"zzz\",\"phoneNumber\":null}"});
        tester.e3().matcher().eq("id_", (Object)3).andEq("e2_id", (Object)8).assertOneMatch();
    }

    @Test
    public void toOne() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{8, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{3, "zzz", 8}).exec();
        tester.target("/e3/3").queryParam("include", new Object[]{"e2"}).put("{\"id\":3,\"e2\":1}").wasOk().bodyEquals(1L, new String[]{"{\"id\":3,\"e2\":{\"id\":1,\"address\":null,\"name\":\"xxx\"},\"name\":\"zzz\",\"phoneNumber\":null}"});
        tester.e3().matcher().eq("id_", (Object)3).andEq("e2_id", (Object)1).assertOneMatch();
    }

    @Test
    public void toMany() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{8, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{3, "zzz", null}).values(new Object[]{4, "aaa", 8}).values(new Object[]{5, "bbb", 8}).exec();
        tester.target("/e2/1").queryParam("include", new Object[]{E2.ADDRESS.getName(), E2.NAME.getName(), E2.E3S.getName()}).put("{\"e3s\":[3,4,5]}").wasOk().bodyEquals(1L, new String[]{"{\"address\":null,\"e3s\":[{\"id\":3,\"name\":\"zzz\",\"phoneNumber\":null},{\"id\":4,\"name\":\"aaa\",\"phoneNumber\":null},{\"id\":5,\"name\":\"bbb\",\"phoneNumber\":null}],\"name\":\"xxx\"}"});
        tester.e3().matcher().eq("e2_id", (Object)1).assertMatches(3);
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @PUT
        @Path(value="e2/{id}")
        public DataResponse<E2> createOrUpdate_E2(@PathParam(value="id") int id, String entityData, @Context UriInfo uriInfo) {
            return AgJaxrs.idempotentCreateOrUpdate(E2.class, (Configuration)this.config).byId((Object)id).clientParams((Map)uriInfo.getQueryParameters()).syncAndSelect(entityData);
        }

        @PUT
        @Path(value="e3")
        public DataResponse<E3> syncE3(@Context UriInfo uriInfo, String requestBody) {
            return AgJaxrs.idempotentFullSync(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).syncAndSelect(requestBody);
        }

        @PUT
        @Path(value="e3/{id}")
        public DataResponse<E3> updateE3(@PathParam(value="id") int id, String data, @Context UriInfo uriInfo) {
            return AgJaxrs.update(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).byId((Object)id).syncAndSelect(data);
        }
    }
}

