/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.PUT;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E1;
import io.agrest.cayenne.cayenne.main.E23;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import java.util.List;
import org.junit.jupiter.api.Test;

public class MapperIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = MapperIT.tester(Resource.class).entitiesAndDependencies(E1.class, E23.class).build();

    @Test
    public void implicitIdMapper() {
        tester.e23().insertColumns(new String[]{"id", "name"}).values(new Object[]{56, "N1"}).values(new Object[]{54, "N2"}).exec();
        tester.target("/id").queryParam("include", new Object[]{"exposedId", "name"}).put("[  {\"exposedId\":58,\"name\":\"N4\"}, {\"exposedId\":56,\"name\":\"N3\"} ]").wasOk().bodyEquals(2L, new String[]{"{\"exposedId\":58,\"name\":\"N4\"},{\"exposedId\":56,\"name\":\"N3\"}"});
        tester.e23().matcher().assertMatches(3);
        tester.e23().matcher().eq("id", (Object)58).andEq("name", (Object)"N4").assertOneMatch();
        tester.e23().matcher().eq("id", (Object)56).andEq("name", (Object)"N3").assertOneMatch();
    }

    @Test
    public void propertyMapper() {
        tester.e1().insertColumns(new String[]{"id", "name", "description"}).values(new Object[]{56, "N1", "D1"}).values(new Object[]{54, "N2", "D2"}).exec();
        tester.target("/prop").queryParam("include", new Object[]{"name", "description"}).put("[  {\"name\":\"N4\",\"description\":\"D4\"}, {\"name\":\"N1\",\"description\":\"D3\"} ]").wasOk().bodyEquals(2L, new String[]{"{\"description\":\"D4\",\"name\":\"N4\"},{\"description\":\"D3\",\"name\":\"N1\"}"});
        tester.e1().matcher().assertMatches(3);
        tester.e1().matcher().eq("name", (Object)"N1").andEq("description", (Object)"D3").assertOneMatch();
        tester.e1().matcher().eq("name", (Object)"N2").andEq("description", (Object)"D2").assertOneMatch();
        tester.e1().matcher().eq("name", (Object)"N4").andEq("description", (Object)"D4").assertOneMatch();
    }

    @Test
    public void propertiesMapper() {
        tester.e1().insertColumns(new String[]{"id", "name", "age", "description"}).values(new Object[]{56, "N1", 1, "D1"}).values(new Object[]{55, "N1", 2, "D2"}).values(new Object[]{54, "N2", 2, "D3"}).exec();
        tester.target("/props").queryParam("include", new Object[]{"name", "age", "description"}).put("[{\"age\":3,\"description\":\"D4\",\"name\":\"N1\"}, {\"age\":2,\"description\":\"D5\",\"name\":\"N1\"}]").wasOk().bodyEquals(2L, new String[]{"{\"age\":3,\"description\":\"D4\",\"name\":\"N1\"},{\"age\":2,\"description\":\"D5\",\"name\":\"N1\"}"});
        tester.e1().matcher().assertMatches(4);
        tester.e1().matcher().eq("name", (Object)"N1").andEq("age", (Object)1).andEq("description", (Object)"D1").assertOneMatch();
        tester.e1().matcher().eq("name", (Object)"N1").andEq("age", (Object)2).andEq("description", (Object)"D5").assertOneMatch();
        tester.e1().matcher().eq("name", (Object)"N2").andEq("age", (Object)2).andEq("description", (Object)"D3").assertOneMatch();
        tester.e1().matcher().eq("name", (Object)"N1").andEq("age", (Object)3).andEq("description", (Object)"D4").assertOneMatch();
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @PUT
        @Path(value="id")
        public DataResponse<E23> implicitIdMapper(@QueryParam(value="include") List<String> includes, String entityData) {
            return AgJaxrs.idempotentCreateOrUpdate(E23.class, (Configuration)this.config).request(AgJaxrs.request((Configuration)this.config).addIncludes(includes).build()).syncAndSelect(entityData);
        }

        @PUT
        @Path(value="prop")
        public DataResponse<E1> propertyMapper(@QueryParam(value="include") List<String> includes, String entityData) {
            return AgJaxrs.idempotentCreateOrUpdate(E1.class, (Configuration)this.config).mapper(new String[]{E1.NAME.getName()}).request(AgJaxrs.request((Configuration)this.config).addIncludes(includes).build()).syncAndSelect(entityData);
        }

        @PUT
        @Path(value="props")
        public DataResponse<E1> propertiesMapper(@QueryParam(value="include") List<String> includes, String entityData) {
            return AgJaxrs.idempotentCreateOrUpdate(E1.class, (Configuration)this.config).mapper(new String[]{E1.NAME.getName(), E1.AGE.getName()}).request(AgJaxrs.request((Configuration)this.config).addIncludes(includes).build()).syncAndSelect(entityData);
        }
    }
}

