/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.PUT;

import io.agrest.DataResponse;
import io.agrest.UpdateBuilder;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E5;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Include_MaxPathDepthIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = Include_MaxPathDepthIT.tester(Resource.class).entitiesAndDependencies(E2.class, E3.class, E5.class).build();

    @BeforeEach
    void insertTestData() {
        tester.e5().insertColumns(new String[]{"id", "name", "date"}).values(new Object[]{45, "T", "2013-01-03"}).exec();
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{8, "A"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id", "e5_id"}).values(new Object[]{3, "zzz", 8, 45}).exec();
    }

    @Test
    public void depth100_Default() {
        tester.target("/e2/8").queryParam("include", new Object[]{"name", "e3s.id", "e3s.e5.id"}).put("{\"name\":\"B\"}").wasOk().bodyEquals(1L, new String[]{"{\"e3s\":[{\"id\":3,\"e5\":{\"id\":45}}],\"name\":\"B\"}"});
    }

    @Test
    public void depth0() {
        tester.target("/e2/8").queryParam("depth", new Object[]{0}).queryParam("include", new Object[]{"name", "e3s.id", "e3s.e5.id"}).put("{\"name\":\"B\"}").wasOk().bodyEquals(1L, new String[]{"{\"name\":\"B\"}"});
    }

    @Test
    public void depth1() {
        tester.target("/e2/8").queryParam("depth", new Object[]{1}).queryParam("include", new Object[]{"name", "e3s.id", "e3s.e5.id"}).put("{\"name\":\"B\"}").wasOk().bodyEquals(1L, new String[]{"{\"e3s\":[{\"id\":3}],\"name\":\"B\"}"});
    }

    @Test
    public void depth2() {
        tester.target("/e2/8").queryParam("depth", new Object[]{2}).queryParam("include", new Object[]{"name", "e3s.id", "e3s.e5.id"}).put("{\"name\":\"B\"}").wasOk().bodyEquals(1L, new String[]{"{\"e3s\":[{\"id\":3,\"e5\":{\"id\":45}}],\"name\":\"B\"}"});
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @PUT
        @Path(value="e2/{id}")
        public DataResponse<E2> createOrUpdate_E2(@PathParam(value="id") int id, String entityData, @Context UriInfo uriInfo, @QueryParam(value="depth") Integer depth) {
            UpdateBuilder builder = AgJaxrs.idempotentCreateOrUpdate(E2.class, (Configuration)this.config).byId((Object)id).clientParams((Map)uriInfo.getQueryParameters());
            if (depth != null) {
                builder.maxPathDepth(depth.intValue());
            }
            return builder.syncAndSelect(entityData);
        }
    }
}

