/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.PUT;

import io.agrest.EntityUpdate;
import io.agrest.SimpleResponse;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class EntityUpdateBindingIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = EntityUpdateBindingIT.tester(Resource.class).entities(E3.class).build();

    @Test
    public void single() {
        tester.e3().insertColumns(new String[]{"id_", "name"}).values(new Object[]{3, "zzz"}).exec();
        tester.target("/e3/updatebinding/3").put("{\"id\":3,\"name\":\"yyy\"}").wasOk().bodyEquals("{}");
        tester.e3().matcher().eq("id_", (Object)3).andEq("name", (Object)"yyy").assertOneMatch();
    }

    @Test
    public void collection() {
        tester.e3().insertColumns(new String[]{"id_", "name"}).values(new Object[]{3, "zzz"}).values(new Object[]{4, "xxx"}).values(new Object[]{5, "mmm"}).exec();
        tester.target("/e3/updatebinding").put("[{\"id\":3,\"name\":\"yyy\"},{\"id\":5,\"name\":\"nnn\"}]").wasOk().bodyEquals("{}");
        tester.e3().matcher().assertMatches(2);
        tester.e3().matcher().eq("id_", (Object)3).andEq("name", (Object)"yyy").assertOneMatch();
        tester.e3().matcher().eq("id_", (Object)5).andEq("name", (Object)"nnn").assertOneMatch();
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @PUT
        @Path(value="e3/updatebinding")
        public SimpleResponse sync_EntityUpdateCollection(@Context UriInfo uriInfo, Collection<EntityUpdate<E3>> entityUpdates) {
            return AgJaxrs.idempotentFullSync(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).sync(entityUpdates);
        }

        @PUT
        @Path(value="e3/updatebinding/{id}")
        public SimpleResponse updateE3_EntityUpdateSingle(@PathParam(value="id") int id, EntityUpdate<E3> update) {
            return AgJaxrs.createOrUpdate(E3.class, (Configuration)this.config).byId((Object)id).sync(update);
        }
    }
}

