/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.PUT;

import io.agrest.DataResponse;
import io.agrest.EntityUpdate;
import io.agrest.cayenne.cayenne.main.E10;
import io.agrest.cayenne.cayenne.main.E11;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E22;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.query.SelectById;
import org.junit.jupiter.api.Test;

public class EntityOverlay_PerRequestIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = EntityOverlay_PerRequestIT.tester(Resource.class).entities(E2.class, E3.class, E4.class, E10.class, E11.class, E22.class).build();

    @Test
    public void requestOverlaidProperties_ConstrainedEntity() {
        tester.e10().insertColumns(new String[]{"id", "c_int"}).values(new Object[]{2, 5}).values(new Object[]{4, 8}).exec();
        tester.e22().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "a"}).values(new Object[]{2, "b"}).exec();
        tester.target("/e10/xyz/2").queryParam("include", new Object[]{"[\"id\",\"cInt\",\"fromRequest\",\"dynamicRelationship.name\"]"}).put("{\"cInt\":88}").wasOk().bodyEquals(1L, new String[]{"{\"id\":2,\"cInt\":89,\"dynamicRelationship\":{\"name\":\"b\"},\"fromRequest\":\"xyz\"}"});
    }

    @Test
    public void defaultIncludes() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{2, "a"}).values(new Object[]{4, "b"}).exec();
        tester.target("/e4/xyz").queryParam("sort", new Object[]{"id"}).put("[{\"id\":2,\"cBoolean\":true,\"cVarchar\":\"c\",\"objectProperty\":\"xxx$\"},{\"id\":4,\"cBoolean\":false,\"cVarchar\":\"d\",\"objectProperty\":\"yyy$\"}]").wasOk().bodyEquals(2L, new String[]{"{\"id\":2,\"cBoolean\":true,\"cDate\":null,\"cDecimal\":null,\"cInt\":null,\"cTime\":null,\"cTimestamp\":null,\"cVarchar\":\"c_x\",\"fromRequest\":\"xyz\",\"objectProperty\":\"c$\"}", "{\"id\":4,\"cBoolean\":false,\"cDate\":null,\"cDecimal\":null,\"cInt\":null,\"cTime\":null,\"cTimestamp\":null,\"cVarchar\":\"d_x\",\"fromRequest\":\"xyz\",\"objectProperty\":\"d$\"}"});
    }

    @Test
    public void overlaidRelatedExclude() {
        tester.e2().insertColumns(new String[]{"id_", "name", "address"}).values(new Object[]{1, "N", "A"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "phone_number", "e2_id"}).values(new Object[]{1, "N", "P", 1}).exec();
        tester.target("/e2/1").queryParam("include", new Object[]{"e3s"}).put("{\"name\":\"Nn\",\"address\":\"Aa\"}").wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"e3s\":[{\"id\":1,\"name\":\"N\"}],\"name\":\"Nn\"}"});
        tester.e2().matcher().eq("id_", (Object)1).andEq("name", (Object)"Nn").andEq("address", (Object)"A").assertOneMatch();
    }

    @Test
    public void overlaidExclude() {
        tester.e2().insertColumns(new String[]{"id_", "name", "address"}).values(new Object[]{1, "N", "A"}).exec();
        tester.target("/e2/1").put("{\"name\":\"Nn\",\"address\":\"Aa\"}").wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"name\":\"Nn\"}"});
        tester.e2().matcher().eq("id_", (Object)1).andEq("name", (Object)"Nn").andEq("address", (Object)"A").assertOneMatch();
    }

    @Test
    public void writablePropFilter_ToManyBlocked() {
        tester.e2().insertColumns(new String[]{"id_", "name", "address"}).values(new Object[]{11, "N", "A"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "phone_number", "e2_id"}).values(new Object[]{35, "N", "P", 11}).exec();
        tester.target("/e2/11/block-e3s-write").queryParam("include", new Object[]{"e3s.id", "id", "name"}).put("{\"e3s\":[],\"name\":\"Nn\"}").wasOk().bodyEquals(1L, new String[]{"{\"id\":11,\"e3s\":[{\"id\":35}],\"name\":\"Nn\"}"});
        tester.e2().matcher().eq("id_", (Object)11).andEq("name", (Object)"Nn").assertOneMatch();
        tester.e3().matcher().eq("e2_id", (Object)11).andEq("name", (Object)"N").assertOneMatch();
    }

    @Test
    public void writablePropFilter_ToOneBlocked() {
        tester.e2().insertColumns(new String[]{"id_", "name", "address"}).values(new Object[]{11, "N", "A"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "phone_number", "e2_id"}).values(new Object[]{35, "N", "P", 11}).exec();
        tester.target("/e3/35/block-e2-write").queryParam("include", new Object[]{"e2.id", "id", "name"}).put("{\"e2\":null,\"name\":\"Nn\"}").wasOk().bodyEquals(1L, new String[]{"{\"id\":35,\"e2\":{\"id\":11},\"name\":\"Nn\"}"});
        tester.e3().matcher().eq("id_", (Object)35).andEq("name", (Object)"Nn").andEq("e2_id", (Object)11).assertOneMatch();
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        private static <T extends Persistent> T findMatching(Class<T> type, Persistent p) {
            return (T)((Persistent)SelectById.query(type, (Object)Cayenne.pkForObject((Persistent)p)).selectOne(p.getObjectContext()));
        }

        @PUT
        @Path(value="e10/{suffix}/{id}")
        public DataResponse<E10> putE10(@Context UriInfo uriInfo, @PathParam(value="suffix") String suffix, @PathParam(value="id") Integer id, EntityUpdate<E10> data) {
            AgEntityOverlay overlay = AgEntity.overlay(E10.class).attribute("fromRequest", String.class, e4 -> suffix).attribute("cInt", Integer.class, e10 -> e10.getCInt() + 1).toOne("dynamicRelationship", E22.class, e10 -> Resource.findMatching(E22.class, (Persistent)e10));
            return AgJaxrs.createOrUpdate(E10.class, (Configuration)this.config).entityOverlay(overlay).byId((Object)id).clientParams((Map)uriInfo.getQueryParameters()).syncAndSelect(data);
        }

        @PUT
        @Path(value="e4/{suffix}")
        public DataResponse<E4> putE4(@Context UriInfo uriInfo, @PathParam(value="suffix") String suffix, List<EntityUpdate<E4>> data) {
            AgEntityOverlay overlay = AgEntity.overlay(E4.class).attribute("fromRequest", String.class, e4 -> suffix).attribute("objectProperty", String.class, E4::getDerived).attribute("cVarchar", String.class, e4 -> e4.getCVarchar() + "_x").toOne("dynamicRelationship", E22.class, e4 -> Resource.findMatching(E22.class, (Persistent)e4));
            return AgJaxrs.createOrUpdate(E4.class, (Configuration)this.config).entityOverlay(overlay).clientParams((Map)uriInfo.getQueryParameters()).syncAndSelect(data);
        }

        @PUT
        @Path(value="e2/{id}")
        public DataResponse<E2> putE2_With_exclude(@Context UriInfo uriInfo, @PathParam(value="id") Integer id, EntityUpdate<E2> data) {
            AgEntityOverlay e2Overlay = AgEntity.overlay(E2.class).readablePropFilter(p -> p.property("address", false)).writablePropFilter(p -> p.property("address", false));
            AgEntityOverlay e3Overlay = AgEntity.overlay(E3.class).readablePropFilter(p -> p.property("phoneNumber", false)).writablePropFilter(p -> p.property("phoneNumber", false));
            return AgJaxrs.createOrUpdate(E2.class, (Configuration)this.config).entityOverlay(e2Overlay).entityOverlay(e3Overlay).clientParams((Map)uriInfo.getQueryParameters()).byId((Object)id).syncAndSelect(data);
        }

        @PUT
        @Path(value="e2/{id}/block-e3s-write")
        public DataResponse<E2> putE2_ToManyNotWritable(@Context UriInfo uriInfo, @PathParam(value="id") Integer id, EntityUpdate<E2> data) {
            AgEntityOverlay e2Overlay = AgEntity.overlay(E2.class).writablePropFilter(p -> p.property(E2.E3S.getName(), false));
            return AgJaxrs.createOrUpdate(E2.class, (Configuration)this.config).entityOverlay(e2Overlay).clientParams((Map)uriInfo.getQueryParameters()).byId((Object)id).syncAndSelect(data);
        }

        @PUT
        @Path(value="e3/{id}/block-e2-write")
        public DataResponse<E3> putE3_ToOneNotWritable(@Context UriInfo uriInfo, @PathParam(value="id") Integer id, EntityUpdate<E3> data) {
            AgEntityOverlay overlay = AgEntity.overlay(E3.class).writablePropFilter(p -> p.property(E3.E2.getName(), false));
            return AgJaxrs.createOrUpdate(E3.class, (Configuration)this.config).entityOverlay(overlay).clientParams((Map)uriInfo.getQueryParameters()).byId((Object)id).syncAndSelect(data);
        }
    }
}

