/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.PUT;

import io.agrest.SimpleResponse;
import io.agrest.cayenne.cayenne.main.E28;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import org.junit.jupiter.api.Test;

public class ConvertersIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = ConvertersIT.tester(Resource.class).entities(E28.class).build();

    @Test
    public void json() {
        String e1 = "[{\"id\":5,\"json\":[1,2]},{\"id\":6,\"json\":{\"a\":1}},{\"id\":7,\"json\":5}]";
        tester.target("/e28/").put(e1).wasCreated();
        tester.e28().matcher().assertMatches(3);
        tester.e28().matcher().eq("id", (Object)5).andEq("json", (Object)"[1,2]").assertOneMatch();
        tester.e28().matcher().eq("id", (Object)6).andEq("json", (Object)"{\"a\":1}").assertOneMatch();
        tester.e28().matcher().eq("id", (Object)7).andEq("json", (Object)"5").assertOneMatch();
        String e2 = "[{\"id\":5,\"json\":[1,3]}]";
        tester.target("/e28/").put(e2).wasOk();
        tester.e28().matcher().assertMatches(3);
        tester.e28().matcher().eq("id", (Object)5).andEq("json", (Object)"[1,3]").assertOneMatch();
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @PUT
        @Path(value="e28")
        public SimpleResponse syncE28(String data) {
            return AgJaxrs.createOrUpdate(E28.class, (Configuration)this.config).sync(data);
        }
    }
}

