/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.PUT;

import io.agrest.AgRequest;
import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.protocol.Exclude;
import io.agrest.protocol.Include;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class AgRequestIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = AgRequestIT.tester(Resource.class).entities(E3.class).build();

    @Test
    public void includes_OverrideByAgRequest() {
        tester.e3().insertColumns(new String[]{"id_", "name"}).values(new Object[]{5, "aaa"}).values(new Object[]{4, "zzz"}).values(new Object[]{2, "bbb"}).values(new Object[]{6, "yyy"}).exec();
        String entity = "[{\"id\":6,\"name\":\"yyy\"},{\"id\":4,\"name\":\"zzz\"},{\"id\":5,\"name\":\"111\"},{\"id\":2,\"name\":\"333\"}]";
        tester.target("/e3_includes").queryParam("include", new Object[]{"id"}).put(entity).wasOk().bodyEquals(4L, new String[]{"{\"name\":\"yyy\"}", "{\"name\":\"zzz\"}", "{\"name\":\"111\"}", "{\"name\":\"333\"}"});
    }

    @Test
    public void excludes_OverrideByAgRequest() {
        tester.e3().insertColumns(new String[]{"id_", "name"}).values(new Object[]{5, "aaa"}).values(new Object[]{4, "zzz"}).values(new Object[]{2, "bbb"}).values(new Object[]{6, "yyy"}).exec();
        String entity = "[{\"id\":6,\"name\":\"yyy\"},{\"id\":4,\"name\":\"zzz\"},{\"id\":5,\"name\":\"111\"},{\"id\":2,\"name\":\"333\"}]";
        tester.target("/e3_excludes").queryParam("exclude", new Object[]{E3.NAME.getName()}).put(entity).wasOk().bodyEquals(4L, new String[]{"{\"name\":\"yyy\",\"phoneNumber\":null}", "{\"name\":\"zzz\",\"phoneNumber\":null}", "{\"name\":\"111\",\"phoneNumber\":null}", "{\"name\":\"333\",\"phoneNumber\":null}"});
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @PUT
        @Path(value="e3_includes")
        public DataResponse<E3> syncE3_includes(@Context UriInfo uriInfo, String requestBody) {
            AgRequest agRequest = AgJaxrs.request((Configuration)this.config).addInclude(new Include("name")).build();
            return AgJaxrs.idempotentFullSync(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).request(agRequest).syncAndSelect(requestBody);
        }

        @PUT
        @Path(value="e3_excludes")
        public DataResponse<E3> syncE3_excludes(@Context UriInfo uriInfo, String requestBody) {
            AgRequest agRequest = AgJaxrs.request((Configuration)this.config).addExclude(new Exclude("id")).build();
            return AgJaxrs.idempotentFullSync(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).request(agRequest).syncAndSelect(requestBody);
        }
    }
}

