/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.POST;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class ReadablePropFilterIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = ReadablePropFilterIT.tester(Resource.class).entitiesAndDependencies(E3.class).build();

    @Test
    public void readConstraints1() {
        tester.target("/e3/constrained").post("{\"name\":\"zzz\"}").wasCreated().replaceId("RID").bodyEquals(1L, new String[]{"{\"id\":RID,\"name\":\"zzz\"}"});
    }

    @Test
    public void include_ReadConstraints() {
        tester.target("/e3/constrained").queryParam("include", new Object[]{"name"}).queryParam("include", new Object[]{"phoneNumber"}).post("{\"name\":\"zzz\",\"phoneNumber\":\"123456\"}").wasCreated().bodyEquals(1L, new String[]{"{\"name\":\"zzz\"}"});
        tester.e3().matcher().assertOneMatch();
        tester.e3().matcher().eq("name", (Object)"zzz").andEq("phone_number", (Object)"123456").assertOneMatch();
    }

    @Test
    public void readConstraints_DisallowRelated() {
        tester.target("/e3/constrained").queryParam("include", new Object[]{E3.E2.getName()}).post("{\"name\":\"zzz\"}").wasCreated().replaceId("RID").bodyEquals(1L, new String[]{"{\"id\":RID,\"name\":\"zzz\"}"});
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @POST
        @Path(value="e3/constrained")
        public DataResponse<E3> insertE3ReadConstrained(@Context UriInfo uriInfo, String requestBody) {
            return AgJaxrs.create(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).readablePropFilter(E3.class, b -> b.idOnly().property("name", true)).syncAndSelect(requestBody);
        }
    }
}

