/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.POST;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E12;
import io.agrest.cayenne.cayenne.main.E12E13;
import io.agrest.cayenne.cayenne.main.E13;
import io.agrest.cayenne.cayenne.main.E17;
import io.agrest.cayenne.cayenne.main.E18;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class ParentIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = ParentIT.tester(Resource.class).entities(E2.class, E3.class, E17.class, E18.class).entitiesAndDependencies(E12.class, E13.class).build();

    @Test
    public void relate_ToMany_New() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{24, "xxx"}).exec();
        tester.target("/e2/24/e3s").post("{\"name\":\"zzz\"}").wasCreated().replaceId("RID").bodyEquals(1L, new String[]{"{\"id\":RID,\"name\":\"zzz\",\"phoneNumber\":null}"});
        tester.e3().matcher().assertOneMatch();
        tester.e3().matcher().eq("e2_id", (Object)24).andEq("name", (Object)"zzz").assertOneMatch();
    }

    @Test
    public void relate_ToMany_New_CompoundId() {
        tester.e17().insertColumns(new String[]{"id1", "id2", "name"}).values(new Object[]{1, 1, "aaa"}).exec();
        tester.target("/e17/e18s").matrixParam("parentId1", new Object[]{1}).matrixParam("parentId2", new Object[]{1}).post("{\"name\":\"xxx\"}").wasCreated().replaceId("RID").bodyEquals(1L, new String[]{"{\"id\":RID,\"name\":\"xxx\"}"});
        tester.e18().matcher().assertOneMatch();
        tester.e18().matcher().eq("e17_id1", (Object)1).andEq("e17_id2", (Object)1).andEq("name", (Object)"xxx").assertOneMatch();
    }

    @Test
    public void relate_ToMany_MixedCollection() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{15, "xxx"}).values(new Object[]{16, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{12, "zzz", 16}).values(new Object[]{60, "yyy", 15}).values(new Object[]{90, "aaa", 15}).exec();
        tester.target("/e2/15/e3s").queryParam("include", new Object[]{"name"}).post("[ {\"id\":60,\"name\":\"123\"}, {\"name\":\"newname\"} ]").wasOk().bodyEquals(2L, new String[]{"{\"name\":\"123\"}", "{\"name\":\"newname\"}"});
        tester.e3().matcher().assertMatches(4);
        tester.e3().matcher().eq("e2_id", (Object)15).assertMatches(3);
        tester.target("/e2/15/e3s").queryParam("include", new Object[]{"name"}).post("[ {\"id\":60,\"name\":\"123\"}, {\"name\":\"newname\"} ]").wasOk().bodyEquals(2L, new String[]{"{\"name\":\"123\"}", "{\"name\":\"newname\"}"});
        tester.e3().matcher().assertMatches(5);
        tester.e3().matcher().eq("e2_id", (Object)15).assertMatches(4);
    }

    @Test
    public void toManyJoin() {
        tester.e12().insertColumns(new String[]{"id"}).values(new Object[]{11}).values(new Object[]{12}).exec();
        tester.e13().insertColumns(new String[]{"id"}).values(new Object[]{14}).values(new Object[]{15}).values(new Object[]{16}).exec();
        tester.target("/e12/12/e1213").queryParam("exclude", new Object[]{"id"}).post("[{\"e13\":15},{\"e13\":14}]").wasCreated().bodyEquals(2L, new String[]{"{},{}"});
        tester.e12_13().matcher().assertMatches(2);
        tester.e12_13().matcher().eq("e12_id", (Object)12).andEq("e13_id", (Object)14).assertOneMatch();
        tester.e12_13().matcher().eq("e12_id", (Object)12).andEq("e13_id", (Object)15).assertOneMatch();
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @POST
        @Path(value="e2/{id}/e3s")
        public DataResponse<E3> createOrUpdateE3sOfE2(@PathParam(value="id") int id, @Context UriInfo uri, String targetData) {
            return AgJaxrs.createOrUpdate(E3.class, (Configuration)this.config).clientParams((Map)uri.getQueryParameters()).parent(E2.class, (Object)id, E2.E3S.getName()).syncAndSelect(targetData);
        }

        @POST
        @Path(value="e12/{id}/e1213")
        public DataResponse<E12E13> create_Joins(@PathParam(value="id") int id, @Context UriInfo info, String entityData) {
            return AgJaxrs.create(E12E13.class, (Configuration)this.config).parent(E12.class, (Object)id, E12.E1213.getName()).clientParams((Map)info.getQueryParameters()).syncAndSelect(entityData);
        }

        @POST
        @Path(value="e17/e18s")
        public DataResponse<E18> createOrUpdateE18s(@Context UriInfo uriInfo, @MatrixParam(value="parentId1") Integer parentId1, @MatrixParam(value="parentId2") Integer parentId2, String targetData) {
            HashMap<String, Integer> parentIds = new HashMap<String, Integer>();
            parentIds.put(E17.ID1.getName(), parentId1);
            parentIds.put(E17.ID2.getName(), parentId2);
            return AgJaxrs.createOrUpdate(E18.class, (Configuration)this.config).parent(E17.class, parentIds, E17.E18S.getName()).clientParams((Map)uriInfo.getQueryParameters()).syncAndSelect(targetData);
        }
    }
}

