/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.POST;

import io.agrest.DataResponse;
import io.agrest.EntityUpdate;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.Persistent;
import org.junit.jupiter.api.Test;

public class NestedIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = NestedIT.tester(Resource.class).entitiesAndDependencies(E2.class, E3.class).build();

    @Test
    public void toOne_AsNewObject() {
        tester.target("/e3").queryParam("include", new Object[]{"name", "e2.id"}).post("{\"e2\":{\"name\":\"new_to_one\"},\"name\":\"MM\"}").wasCreated().bodyEquals(1L, new String[]{"{\"e2\":null,\"name\":\"MM\"}"});
        tester.e3().matcher().assertOneMatch();
        tester.e2().matcher().assertOneMatch();
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @POST
        @Path(value="e3")
        public DataResponse<E3> create(@Context UriInfo uriInfo, EntityUpdate<E3> update) {
            DataResponse e3Response = AgJaxrs.create(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).syncAndSelect(update);
            int e2Id = Cayenne.intPKForObject((Persistent)((Persistent)e3Response.getData().get(0)));
            EntityUpdate e2Update = update.getToOne(E3.E2.getName());
            if (e2Update != null) {
                AgJaxrs.create(E2.class, (Configuration)this.config).parent(E3.class, (Object)e2Id, E3.E2.getName()).sync(e2Update);
            }
            return e3Response;
        }
    }
}

