/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.POST;

import io.agrest.DataResponse;
import io.agrest.SimpleResponse;
import io.agrest.cayenne.cayenne.main.E17;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E31;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class BasicIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = BasicIT.tester(Resource.class).entities(E3.class, E4.class, E17.class, E31.class).build();

    @Test
    public void basic() {
        tester.target("/e4").post("{\"cVarchar\":\"zzz\"}").wasCreated().replaceId("RID").bodyEquals(1L, new String[]{"{\"id\":RID,\"cBoolean\":null,\"cDate\":null,\"cDecimal\":null,\"cInt\":null,\"cTime\":null,\"cTimestamp\":null,\"cVarchar\":\"zzz\"}"});
        tester.e4().matcher().assertOneMatch();
        tester.e4().matcher().eq("c_varchar", (Object)"zzz").assertOneMatch();
        tester.target("/e4").post("{\"cVarchar\":\"TTTT\"}").wasCreated().replaceId("RID").bodyEquals(1L, new String[]{"{\"id\":RID,\"cBoolean\":null,\"cDate\":null,\"cDecimal\":null,\"cInt\":null,\"cTime\":null,\"cTimestamp\":null,\"cVarchar\":\"TTTT\"}"});
        tester.e4().matcher().assertMatches(2);
        tester.e4().matcher().eq("c_varchar", (Object)"TTTT").assertOneMatch();
    }

    @Test
    public void idCalledId() {
        tester.target("/e31").post("{\"id\":5,\"name\":\"31\"}").wasCreated().bodyEquals(1L, new String[]{"{\"id\":5,\"name\":\"31\"}"});
        tester.e31().matcher().assertOneMatch();
        tester.e31().matcher().eq("id", (Object)5L).assertOneMatch();
    }

    @Test
    public void compoundId() {
        tester.target("/e17").queryParam("id1", new Object[]{1}).queryParam("id2", new Object[]{1}).post("{\"name\":\"xxx\"}").wasCreated().bodyEquals(1L, new String[]{"{\"id\":{\"id1\":1,\"id2\":1},\"id1\":1,\"id2\":1,\"name\":\"xxx\"}"});
    }

    @Test
    public void sync_NoData() {
        tester.target("/e4/sync").post("{\"cVarchar\":\"zzz\"}").wasCreated().bodyEquals("{}");
        tester.e4().matcher().assertOneMatch();
        tester.e4().matcher().eq("c_varchar", (Object)"zzz").assertOneMatch();
    }

    @Test
    public void bulk() {
        tester.target("/e3/").queryParam("exclude", new Object[]{"id"}).queryParam("include", new Object[]{E3.NAME.getName()}).post("[{\"name\":\"aaa\"},{\"name\":\"zzz\"},{\"name\":\"bbb\"},{\"name\":\"yyy\"}]").wasCreated().bodyEquals(4L, new String[]{"{\"name\":\"aaa\"},{\"name\":\"zzz\"},{\"name\":\"bbb\"},{\"name\":\"yyy\"}"});
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @POST
        @Path(value="e3")
        public DataResponse<E3> create(@Context UriInfo uriInfo, String requestBody) {
            return AgJaxrs.create(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).syncAndSelect(requestBody);
        }

        @POST
        @Path(value="e4")
        public DataResponse<E4> createE4(String requestBody) {
            return AgJaxrs.create(E4.class, (Configuration)this.config).syncAndSelect(requestBody);
        }

        @POST
        @Path(value="e4/sync")
        public SimpleResponse createE4_DefaultData(String requestBody) {
            return AgJaxrs.create(E4.class, (Configuration)this.config).sync(requestBody);
        }

        @POST
        @Path(value="e17")
        public DataResponse<E17> createE17(@Context UriInfo uriInfo, @QueryParam(value="id1") Integer id1, @QueryParam(value="id2") Integer id2, String requestBody) {
            HashMap<String, Integer> ids = new HashMap<String, Integer>();
            ids.put(E17.ID1.getName(), id1);
            ids.put(E17.ID2.getName(), id2);
            return AgJaxrs.create(E17.class, (Configuration)this.config).byId(ids).syncAndSelect(requestBody);
        }

        @POST
        @Path(value="e31")
        public DataResponse<E31> createE31(@Context UriInfo uriInfo, String requestBody) {
            return AgJaxrs.create(E31.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).syncAndSelect(requestBody);
        }
    }
}

