/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.SelectBuilder;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Sort_MaxPathDepthIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = Sort_MaxPathDepthIT.tester(Resource.class).entitiesAndDependencies(E2.class, E3.class).build();

    @BeforeEach
    void insertTestData() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{8, "yyy"}).values(new Object[]{7, "aaa"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{3, "zzz", 8}).values(new Object[]{4, "bbb", 7}).exec();
    }

    @Test
    public void depth100_Default() {
        tester.target("/e3").queryParam("include", new Object[]{"id"}).queryParam("sort", new Object[]{"e2.name"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":4}", "{\"id\":3}"});
    }

    @Test
    public void depth0() {
        tester.target("/e3").queryParam("depth", new Object[]{0}).queryParam("include", new Object[]{"id"}).queryParam("sort", new Object[]{"name"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":4}", "{\"id\":3}"});
    }

    @Test
    public void depth0_ByRelated() {
        tester.target("/e3").queryParam("depth", new Object[]{0}).queryParam("include", new Object[]{"id"}).queryParam("sort", new Object[]{"e2.name"}).get().wasBadRequest();
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e3")
        public DataResponse<E3> getE3(@Context UriInfo uriInfo, @QueryParam(value="depth") Integer depth) {
            SelectBuilder builder = AgJaxrs.select(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters());
            if (depth != null) {
                builder.maxPathDepth(depth.intValue());
            }
            return builder.get();
        }
    }
}

