/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class SortIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = SortIT.tester(Resource.class).entitiesAndDependencies(E4.class).build();

    @Test
    public void sort_ById() {
        tester.e4().insertColumns(new String[]{"id"}).values(new Object[]{2}).values(new Object[]{1}).values(new Object[]{3}).exec();
        tester.target("/e4").queryParam("sort", new Object[]{"[{\"property\":\"id\",\"direction\":\"DESC\"}]"}).queryParam("include", new Object[]{"id"}).get().wasOk().bodyEquals(3L, new String[]{"{\"id\":3}", "{\"id\":2}", "{\"id\":1}"});
    }

    @Test
    public void sort_Invalid() {
        tester.target("/e4").queryParam("sort", new Object[]{"[{\"property\":\"xyz\",\"direction\":\"DESC\"}]"}).queryParam("include", new Object[]{"id"}).get().wasBadRequest().bodyEquals("{\"message\":\"Invalid path 'xyz' for 'E4'\"}");
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e4")
        public DataResponse<E4> getE4(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E4.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

