/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.runtime.AgRuntimeBuilder;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class SkipNullsIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = SkipNullsIT.tester(Resource.class).entitiesAndDependencies(E2.class, E3.class).agCustomizer(AgRuntimeBuilder::skipNullProperties).build();

    @Test
    public void attributes() {
        tester.e3().insertColumns(new String[]{"id_", "name"}).values(new Object[]{6, null}).values(new Object[]{7, "yyy"}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id", "name"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":6}", "{\"id\":7,\"name\":\"yyy\"}"});
    }

    @Test
    public void relationships() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "e2_id"}).values(new Object[]{6, 1}).values(new Object[]{7, null}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id", "e2.id"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":6,\"e2\":{\"id\":1}}", "{\"id\":7}"});
    }

    @Test
    public void relatedAttributes() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, null}).exec();
        tester.e3().insertColumns(new String[]{"id_", "e2_id"}).values(new Object[]{6, 1}).values(new Object[]{7, 2}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id", "e2"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":6,\"e2\":{\"id\":1,\"name\":\"xxx\"}}", "{\"id\":7,\"e2\":{\"id\":2}}"});
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e3")
        public DataResponse<E3> getE3(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

