/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class SizeConstraintsIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = SizeConstraintsIT.tester(Resource.class).entities(E4.class).build();

    @Test
    public void noClientLimit() {
        tester.e4().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).values(new Object[]{3}).exec();
        tester.target("/e4/limit").queryParam("sort", new Object[]{"id"}).queryParam("include", new Object[]{"id"}).get().wasOk().bodyEquals(3L, new String[]{"{\"id\":1},{\"id\":2}"});
    }

    @Test
    public void clientLimitBelowServerLimit() {
        tester.e4().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).values(new Object[]{3}).exec();
        tester.target("/e4/limit").queryParam("sort", new Object[]{"id"}).queryParam("include", new Object[]{"id"}).queryParam("limit", new Object[]{"1"}).get().wasOk().bodyEquals(3L, new String[]{"{\"id\":1}"});
    }

    @Test
    public void clientLimitExceedsServerLimit() {
        tester.e4().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).values(new Object[]{3}).exec();
        tester.target("/e4/limit").queryParam("sort", new Object[]{"id"}).queryParam("include", new Object[]{"id"}).queryParam("limit", new Object[]{"5"}).get().wasOk().bodyEquals(3L, new String[]{"{\"id\":1},{\"id\":2}"});
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e4/limit")
        public DataResponse<E4> limit(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E4.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).limit(2).get();
        }
    }
}

