/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.CayenneResolvers;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.agrest.resolver.BaseRootDataResolver;
import io.agrest.resolver.RootDataResolver;
import io.agrest.runtime.processor.select.SelectContext;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.junit.jupiter.api.Test;

public class Resolvers_RootIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = Resolvers_RootIT.tester(Resource.class).entities(E2.class, E3.class).build();

    @Test
    public void viaQueryResolver() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "aaa"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", null}).exec();
        tester.target("/e2_standard_query").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"name"}).queryParam("include", new Object[]{"e3s.name"}).queryParam("exp", new Object[]{"id < 3"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"e3s\":[{\"name\":\"yyy\"}],\"name\":\"xxx\"}", "{\"id\":2,\"e3s\":[],\"name\":\"aaa\"}"});
        tester.assertQueryCount(1);
    }

    @Test
    public void viaCustomResolver() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "aaa"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", null}).exec();
        tester.target("/e2_custom_query").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"name"}).queryParam("include", new Object[]{"e3s.name"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":2,\"e3s\":[],\"name\":\"n_2\"}", "{\"id\":1,\"e3s\":[{\"name\":\"yyy\"}],\"name\":\"n_1\"}"});
        tester.assertQueryCount(1);
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e2_standard_query")
        public DataResponse<E2> e2_standard_query(@Context UriInfo uriInfo) {
            AgEntityOverlay e2Overlay = AgEntity.overlay(E2.class).dataResolverFactory(CayenneResolvers.rootViaQuery()).relatedDataResolver("e3s", CayenneResolvers.relatedViaParentPrefetch());
            return AgJaxrs.select(E2.class, (Configuration)this.config).entityOverlay(e2Overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e2_custom_query")
        public DataResponse<E2> e2_custom_query(@Context UriInfo uriInfo) {
            AgEntityOverlay e2Overlay = AgEntity.overlay(E2.class).dataResolver((RootDataResolver)new CustomE2Resolver()).relatedDataResolver("e3s", CayenneResolvers.relatedViaQueryWithParentIds());
            return AgJaxrs.select(E2.class, (Configuration)this.config).entityOverlay(e2Overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }

    static class CustomE2Resolver
    extends BaseRootDataResolver<E2> {
        CustomE2Resolver() {
        }

        protected void doAssembleQuery(SelectContext<E2> context) {
        }

        protected List<E2> doFetchData(SelectContext<E2> context) {
            return Arrays.asList(this.e2(2), this.e2(1));
        }

        private E2 e2(int i) {
            E2 e2 = new E2();
            e2.setName("n_" + i);
            e2.setObjectId(ObjectId.of((String)"e2", (String)"id_", (Object)i));
            return e2;
        }
    }
}

