/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.CayenneResolvers;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class Resolvers_Related_ToOneIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = Resolvers_Related_ToOneIT.tester(Resource.class).entities(E2.class, E3.class).build();

    @Test
    public void jointPrefetchResolver() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", null}).exec();
        tester.target("/e3_joint_prefetch").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"name"}).queryParam("include", new Object[]{"e2.name"}).queryParam("exp", new Object[]{"id > 3"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":8,\"e2\":{\"name\":\"xxx\"},\"name\":\"yyy\"}", "{\"id\":9,\"e2\":null,\"name\":\"zzz\"}"});
        tester.assertQueryCount(1);
    }

    @Test
    public void queryWithParentIdsResolver() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", null}).exec();
        tester.target("/e3_query_with_parent_ids").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"name"}).queryParam("include", new Object[]{"e2.name"}).queryParam("exp", new Object[]{"id > 3"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":8,\"e2\":{\"name\":\"xxx\"},\"name\":\"yyy\"}", "{\"id\":9,\"e2\":null,\"name\":\"zzz\"}"});
        tester.assertQueryCount(2);
    }

    @Test
    public void queryWithParentIdsResolver_Pagination() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "aaa"}).values(new Object[]{2, "bbb"}).values(new Object[]{3, "ccc"}).values(new Object[]{4, "ddd"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "aaa3", 1}).values(new Object[]{9, "bbb3", 2}).values(new Object[]{10, "ccc3", 3}).values(new Object[]{11, "ddd3", 4}).exec();
        tester.target("/e3_query_with_parent_ids").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"e2.id"}).queryParam("sort", new Object[]{"id"}).queryParam("limit", new Object[]{2}).get().wasOk().bodyEquals(4L, new String[]{"{\"id\":8,\"e2\":{\"id\":1}}", "{\"id\":9,\"e2\":{\"id\":2}}"});
        tester.assertQueryCount(2);
    }

    @Test
    public void queryWithParentQualifierResolver() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", null}).exec();
        tester.target("/e3_query_with_parent_qualifier").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"name"}).queryParam("include", new Object[]{"e2.name"}).queryParam("exp", new Object[]{"id > 3"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":8,\"e2\":{\"name\":\"xxx\"},\"name\":\"yyy\"}", "{\"id\":9,\"e2\":null,\"name\":\"zzz\"}"});
        tester.assertQueryCount(2);
    }

    @Test
    public void queryWithParentQualifierResolver_NoFetchIfNoParent() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", null}).exec();
        tester.target("/e3_query_with_parent_qualifier").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"name"}).queryParam("include", new Object[]{"e2.name"}).queryParam("exp", new Object[]{"id > 9"}).get().wasOk().bodyEquals(0L, new String[0]);
        tester.assertQueryCount(1);
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e3_joint_prefetch")
        public DataResponse<E3> e3_joint_prefetch(@Context UriInfo uriInfo) {
            AgEntityOverlay e3Overlay = AgEntity.overlay(E3.class).relatedDataResolver("e2", CayenneResolvers.relatedViaParentPrefetch());
            return AgJaxrs.select(E3.class, (Configuration)this.config).entityOverlay(e3Overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e3_query_with_parent_ids")
        public DataResponse<E3> e3_query_with_parent_ids(@Context UriInfo uriInfo) {
            AgEntityOverlay e3Overlay = AgEntity.overlay(E3.class).relatedDataResolver("e2", CayenneResolvers.relatedViaQueryWithParentIds());
            return AgJaxrs.select(E3.class, (Configuration)this.config).entityOverlay(e3Overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e3_query_with_parent_qualifier")
        public DataResponse<E3> e3_query_with_parent_qualifier(@Context UriInfo uriInfo) {
            AgEntityOverlay e3Overlay = AgEntity.overlay(E3.class).relatedDataResolver("e2", CayenneResolvers.relatedViaQueryWithParentExp());
            return AgJaxrs.select(E3.class, (Configuration)this.config).entityOverlay(e3Overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

