/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.CayenneResolvers;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class Resolvers_Related_ToManyIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = Resolvers_Related_ToManyIT.tester(Resource.class).entities(E2.class, E3.class).build();

    @Test
    public void jointPrefetchResolver() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "aaa"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", null}).exec();
        tester.target("/e2_joint_prefetch").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"name"}).queryParam("include", new Object[]{"e3s.name"}).queryParam("exp", new Object[]{"id < 3"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"e3s\":[{\"name\":\"yyy\"}],\"name\":\"xxx\"}", "{\"id\":2,\"e3s\":[],\"name\":\"aaa\"}"});
        tester.assertQueryCount(1);
    }

    @Test
    public void queryWithParentIdsResolver() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "aaa"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", null}).exec();
        tester.target("/e2_query_with_parent_ids").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"name"}).queryParam("include", new Object[]{"e3s.name"}).queryParam("exp", new Object[]{"id < 3"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"e3s\":[{\"name\":\"yyy\"}],\"name\":\"xxx\"}", "{\"id\":2,\"e3s\":[],\"name\":\"aaa\"}"});
        tester.assertQueryCount(2);
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e2_joint_prefetch")
        public DataResponse<E2> e2_joint_prefetch(@Context UriInfo uriInfo) {
            AgEntityOverlay e2Overlay = AgEntity.overlay(E2.class).relatedDataResolver("e3s", CayenneResolvers.relatedViaParentPrefetch());
            return AgJaxrs.select(E2.class, (Configuration)this.config).entityOverlay(e2Overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e2_query_with_parent_ids")
        public DataResponse<E2> e2_query_with_parent_ids(@Context UriInfo uriInfo) {
            AgEntityOverlay e2Overlay = AgEntity.overlay(E2.class).relatedDataResolver("e3s", CayenneResolvers.relatedViaQueryWithParentIds());
            return AgJaxrs.select(E2.class, (Configuration)this.config).entityOverlay(e2Overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

