/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.AgException;
import io.agrest.AgResponse;
import io.agrest.SimpleResponse;
import io.agrest.cayenne.CayenneResolvers;
import io.agrest.cayenne.GET.Resolvers_CombinationsIT;
import io.agrest.cayenne.cayenne.main.E25;
import io.agrest.cayenne.pojo.model.PX1;
import io.agrest.cayenne.pojo.runtime.PX1RootResolver;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.agrest.resolver.RelatedDataResolverFactory;
import io.agrest.resolver.RootDataResolver;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class Resolvers_PojoToPersistentIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = Resolvers_PojoToPersistentIT.tester(Resource.class).entities(E25.class).build();

    @ParameterizedTest
    @EnumSource(value=Resolvers_CombinationsIT.Overlay.class)
    public void fail(Resolvers_CombinationsIT.Overlay overlay) {
        tester.target("/px1").queryParam("overlay", new Object[]{overlay}).queryParam("include", new Object[]{"e25"}).get().wasServerError().bodyEquals("{\"message\":\"Entity 'PX1' is not mapped in Cayenne, so its relationship 'e25' can't be resolved with a Cayenne resolver\"}");
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="px1")
        public AgResponse px1(@QueryParam(value="overlay") Resolvers_CombinationsIT.Overlay overlay, @Context UriInfo uriInfo) {
            AgEntityOverlay px1Overlay = AgEntity.overlay(PX1.class).dataResolver((RootDataResolver)new PX1RootResolver()).toOne("e25", E25.class, this.resolverFactory(overlay));
            try {
                return AgJaxrs.select(PX1.class, (Configuration)this.config).entityOverlay(px1Overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
            }
            catch (AgException e) {
                return SimpleResponse.of((int)500, (String)e.getCause().getMessage());
            }
        }

        RelatedDataResolverFactory resolverFactory(Resolvers_CombinationsIT.Overlay o) {
            switch (o) {
                case joint: {
                    return CayenneResolvers.relatedViaParentPrefetch();
                }
                case parentExp: {
                    return CayenneResolvers.relatedViaQueryWithParentExp();
                }
                case parentId: {
                    return CayenneResolvers.relatedViaQueryWithParentIds();
                }
            }
            throw new IllegalStateException("?");
        }
    }
}

