/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.CayenneResolvers;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E5;
import io.agrest.cayenne.persister.ICayennePersister;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SelectById;
import org.junit.jupiter.api.Test;

public class Resolvers_MixedIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = Resolvers_MixedIT.tester(Resource.class).entitiesAndDependencies(E2.class, E3.class, E5.class).build();

    @Test
    public void alt_resolver__parentids_joint_prefetch() {
        tester.e5().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "e5_1"}).values(new Object[]{2, "e5_2"}).values(new Object[]{3, "e5_3"}).exec();
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "e2_1"}).values(new Object[]{2, "e2_2"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e5_id", "e2_id"}).values(new Object[]{34, "e3_1", 1, 2}).values(new Object[]{11, "e3_2", 2, null}).values(new Object[]{13, "e3_3", 3, 1}).exec();
        tester.target("/test_alt_resolver__parentids_joint_prefetch").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"e3s.name"}).queryParam("include", new Object[]{"e3s.e2.name"}).queryParam("exp", new Object[]{"id < 3"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"e3s\":[{\"e2\":{\"name\":\"e2_2\"},\"name\":\"e3_1\"}]}", "{\"id\":2,\"e3s\":[{\"e2\":null,\"name\":\"e3_2\"}]}"});
        tester.assertQueryCount(2);
    }

    @Test
    public void alt_mix_up_relations() {
        tester.e5().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "e5_1"}).values(new Object[]{2, "e5_2"}).values(new Object[]{3, "e5_3"}).exec();
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "e2_1"}).values(new Object[]{2, "e2_2"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name"}).values(new Object[]{2, "e3_2"}).values(new Object[]{1, "e3_1"}).values(new Object[]{3, "e3_3"}).exec();
        tester.target("/test_mix_up_relations").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"e3s.name"}).queryParam("include", new Object[]{"e3s.ex.name"}).queryParam("exp", new Object[]{"id < 3"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"e3s\":[{\"ex\":{\"name\":\"e3_2\"},\"name\":\"e2_2\"}]}", "{\"id\":2,\"e3s\":[]}"});
        tester.assertQueryCount(4);
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="test_alt_resolver__parentids_joint_prefetch")
        public DataResponse<E5> test_alt_resolver__parentids_joint_prefetch(@Context UriInfo uriInfo) {
            AgEntityOverlay o1 = AgEntity.overlay(E5.class).relatedDataResolver(E5.E3S.getName(), CayenneResolvers.relatedViaQueryWithParentIds());
            AgEntityOverlay o2 = AgEntity.overlay(E3.class).relatedDataResolver(E3.E2.getName(), CayenneResolvers.relatedViaParentPrefetch());
            return AgJaxrs.select(E5.class, (Configuration)this.config).entityOverlay(o1).entityOverlay(o2).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="test_mix_up_relations")
        public DataResponse<E5> test_mix_up_relations(@Context UriInfo uriInfo) {
            ObjectContext context = ((ICayennePersister)AgJaxrs.runtime((Configuration)this.config).service(ICayennePersister.class)).sharedContext();
            AgEntityOverlay o1 = AgEntity.overlay(E5.class).toMany(E5.E3S.getName(), E2.class, e5 -> ObjectSelect.query(E2.class).where(ExpressionFactory.greaterDbExp((String)"id_", (Object)Cayenne.longPKForObject((Persistent)e5))).select(context));
            AgEntityOverlay o2 = AgEntity.overlay(E2.class).toOne("ex", E3.class, e2 -> (E3)((Object)((Object)SelectById.query(E3.class, (Object)Cayenne.intPKForObject((Persistent)e2)).selectOne(context))));
            return AgJaxrs.select(E5.class, (Configuration)this.config).entityOverlay(o1).entityOverlay(o2).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

