/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.CayenneResolvers;
import io.agrest.cayenne.cayenne.main.E15;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E5;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.agrest.resolver.RelatedDataResolverFactory;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class Resolvers_CombinationsIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = Resolvers_CombinationsIT.tester(Resource.class).entities(E2.class, E3.class, E5.class).entitiesAndDependencies(E15.class).build();

    @BeforeEach
    void loadData() {
        tester.e5().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "e5_1"}).values(new Object[]{2, "e5_2"}).values(new Object[]{3, "e5_3"}).exec();
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "e2_1"}).values(new Object[]{2, "e2_2"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e5_id", "e2_id"}).values(new Object[]{34, "e3_1", 1, 2}).values(new Object[]{11, "e3_2", 2, null}).values(new Object[]{13, "e3_3", 3, 1}).exec();
        tester.e15().insertColumns(new String[]{"long_id", "name"}).values(new Object[]{1L, "e15_1"}).values(new Object[]{2L, "e15_2"}).values(new Object[]{3L, "e15_3"}).exec();
        tester.e15_5().insertColumns(new String[]{"e15_id", "e5_id"}).values(new Object[]{1L, 1}).values(new Object[]{2L, 3}).values(new Object[]{3L, 3}).exec();
    }

    private static Stream<Arguments> provideTestInputs() {
        return Stream.of(Arguments.of((Object[])new Object[]{Overlay.joint, Overlay.parentExp, 2}), Arguments.of((Object[])new Object[]{Overlay.joint, Overlay.parentId, 2}), Arguments.of((Object[])new Object[]{Overlay.parentExp, Overlay.parentId, 3}), Arguments.of((Object[])new Object[]{Overlay.parentExp, Overlay.joint, 2}), Arguments.of((Object[])new Object[]{Overlay.parentId, Overlay.joint, 2}), Arguments.of((Object[])new Object[]{Overlay.parentId, Overlay.parentExp, 3}), Arguments.of((Object[])new Object[]{Overlay.joint, Overlay.joint, 1}), Arguments.of((Object[])new Object[]{Overlay.parentExp, Overlay.parentExp, 3}), Arguments.of((Object[])new Object[]{Overlay.parentId, Overlay.parentId, 3}));
    }

    @ParameterizedTest
    @MethodSource(value={"provideTestInputs"})
    public void toManyToOne(Overlay o1, Overlay o2, int queryCount) {
        tester.target("/tomany_toone").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"e3s.name"}).queryParam("include", new Object[]{"e3s.e2.name"}).queryParam("exp", new Object[]{"id < 3"}).queryParam("sort", new Object[]{"id"}).queryParam("o1", new Object[]{o1}).queryParam("o2", new Object[]{o2}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"e3s\":[{\"e2\":{\"name\":\"e2_2\"},\"name\":\"e3_1\"}]}", "{\"id\":2,\"e3s\":[{\"e2\":null,\"name\":\"e3_2\"}]}"});
        tester.assertQueryCount(queryCount);
    }

    @ParameterizedTest
    @MethodSource(value={"provideTestInputs"})
    public void toOneToMany(Overlay o1, Overlay o2, int queryCount) {
        tester.target("/toone_tomany").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"e5.name"}).queryParam("include", new Object[]{"e5.e15s.name"}).queryParam("exp", new Object[]{"id < 30"}).queryParam("sort", new Object[]{"id"}).queryParam("o1", new Object[]{o1}).queryParam("o2", new Object[]{o2}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":11,\"e5\":{\"e15s\":[],\"name\":\"e5_2\"}}", "{\"id\":13,\"e5\":{\"e15s\":[{\"name\":\"e15_2\"},{\"name\":\"e15_3\"}],\"name\":\"e5_3\"}}"});
        tester.assertQueryCount(queryCount);
    }

    public static enum Overlay {
        joint,
        parentExp,
        parentId;

    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="tomany_toone")
        public DataResponse<E5> tomany_toone(@QueryParam(value="o1") Overlay e5o, @QueryParam(value="o2") Overlay e3o, @Context UriInfo uriInfo) {
            AgEntityOverlay o1 = AgEntity.overlay(E5.class).relatedDataResolver(E5.E3S.getName(), this.resolverFactory(e5o));
            AgEntityOverlay o2 = AgEntity.overlay(E3.class).relatedDataResolver(E3.E2.getName(), this.resolverFactory(e3o));
            return AgJaxrs.select(E5.class, (Configuration)this.config).entityOverlay(o1).entityOverlay(o2).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="toone_tomany")
        public DataResponse<E3> toone_tomany(@QueryParam(value="o1") Overlay e5o, @QueryParam(value="o2") Overlay e3o, @Context UriInfo uriInfo) {
            AgEntityOverlay o1 = AgEntity.overlay(E3.class).relatedDataResolver(E3.E5.getName(), this.resolverFactory(e3o));
            AgEntityOverlay o2 = AgEntity.overlay(E5.class).relatedDataResolver(E5.E15S.getName(), this.resolverFactory(e5o));
            return AgJaxrs.select(E3.class, (Configuration)this.config).entityOverlay(o1).entityOverlay(o2).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        RelatedDataResolverFactory resolverFactory(Overlay o) {
            switch (o.ordinal()) {
                case 0: {
                    return CayenneResolvers.relatedViaParentPrefetch();
                }
                case 1: {
                    return CayenneResolvers.relatedViaQueryWithParentExp();
                }
                case 2: {
                    return CayenneResolvers.relatedViaQueryWithParentIds();
                }
            }
            throw new IllegalStateException("?");
        }
    }
}

