/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class Resolvers_AutoDetectIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = Resolvers_AutoDetectIT.tester(Resource.class).entities(E2.class, E3.class).build();

    @Test
    public void viaParentExpResolver() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", null}).values(new Object[]{10, "aaa", 2}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id", "name", "e2.name"}).get().wasOk().bodyEquals(3L, new String[]{"{\"id\":8,\"e2\":{\"name\":\"xxx\"},\"name\":\"yyy\"}", "{\"id\":9,\"e2\":null,\"name\":\"zzz\"}", "{\"id\":10,\"e2\":{\"name\":\"yyy\"},\"name\":\"aaa\"}"});
        tester.assertQueryCount(2);
    }

    @Test
    public void viaParentIdsResolver() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", null}).values(new Object[]{10, "aaa", 2}).values(new Object[]{11, "bbb", 2}).values(new Object[]{12, "ccc", 2}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id", "name", "e2.name"}).queryParam("start", new Object[]{1}).queryParam("limit", new Object[]{2}).get().wasOk().bodyEquals(5L, new String[]{"{\"id\":9,\"e2\":null,\"name\":\"zzz\"}", "{\"id\":10,\"e2\":{\"name\":\"yyy\"},\"name\":\"aaa\"}"});
        tester.assertQueryCount(3);
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e3")
        public DataResponse<E3> e3(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

