/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.Persistent;
import org.junit.jupiter.api.Test;

public class Request_EntityAttributeIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = Request_EntityAttributeIT.tester(Resource.class).entities(E3.class, E4.class).build();

    @Test
    public void request_Property() {
        tester.e4().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).exec();
        tester.target("/e4/calc_property").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"x"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"x\":\"y_1\"},{\"id\":2,\"x\":\"y_2\"}"});
    }

    @Test
    public void request_Property_Exclude() {
        tester.e4().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).exec();
        tester.target("/e4/calc_property").queryParam("include", new Object[]{"id"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1},{\"id\":2}"});
    }

    @Test
    public void request_ShadowProperty() {
        tester.e3().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "x"}).values(new Object[]{8, "y"}).exec();
        tester.target("/e3/custom_encoding").queryParam("include", new Object[]{"name"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"name\":\"_x_\"},{\"name\":\"_y_\"}"});
    }

    @Test
    public void request_ShadowProperty_Exclude() {
        tester.e3().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "x"}).values(new Object[]{2, "y"}).exec();
        tester.target("/e3/custom_encoding").queryParam("include", new Object[]{"id"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1},{\"id\":2}"});
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e4/calc_property")
        public DataResponse<E4> property_WithReader(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E4.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).entityAttribute("x", String.class, o -> "y_" + Cayenne.intPKForObject((Persistent)o)).get();
        }

        @GET
        @Path(value="e3/custom_encoding")
        public DataResponse<E3> replaceProperty_WithReader(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).entityAttribute(E3.NAME.getName(), String.class, o -> "_" + o.getName() + "_").get();
        }
    }
}

