/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.access.ReadFilter;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.Persistent;
import org.junit.jupiter.api.Test;

public class ReadFilter_OverlayIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = ReadFilter_OverlayIT.tester(Resource.class).entities(E2.class, E3.class, E4.class).agCustomizer(ab -> ab.entityOverlay(AgEntity.overlay(E2.class).readFilter(ReadFilter_OverlayIT.evenFilter())).entityOverlay(AgEntity.overlay(E3.class).readFilter(ReadFilter_OverlayIT.oddFilter())).entityOverlay(AgEntity.overlay(E4.class).readFilter(ReadFilter_OverlayIT.evenFilter()))).build();

    static <T extends DataObject> ReadFilter<T> evenFilter() {
        return o -> Cayenne.intPKForObject((Persistent)o) % 2 == 0;
    }

    static <T extends DataObject> ReadFilter<T> oddFilter() {
        return o -> Cayenne.intPKForObject((Persistent)o) % 2 != 0;
    }

    @Test
    public void rootFilter_InRequest() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{1, "a"}).values(new Object[]{2, "xyz"}).values(new Object[]{3, "xyz"}).values(new Object[]{4, "b"}).values(new Object[]{5, "c"}).values(new Object[]{6, "d"}).exec();
        tester.target("/e4_by_prop/xyz").queryParam("include", new Object[]{"id", "cVarchar"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":2,\"cVarchar\":\"xyz\"}"});
    }

    @Test
    public void relatedFilter_ToOne() {
        tester.e2().insertColumns(new String[]{"id_"}).values(new Object[]{2}).values(new Object[]{3}).exec();
        tester.e3().insertColumns(new String[]{"id_", "e2_id"}).values(new Object[]{1, 2}).values(new Object[]{2, 2}).values(new Object[]{3, 3}).values(new Object[]{4, 3}).exec();
        tester.target("/e3_nested_filter").queryParam("include", new Object[]{"id", "e2.id"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"e2\":{\"id\":2}}", "{\"id\":3,\"e2\":null}"});
    }

    @Test
    public void relatedFilter_ToMany() {
        tester.e2().insertColumns(new String[]{"id_"}).values(new Object[]{2}).values(new Object[]{3}).exec();
        tester.e3().insertColumns(new String[]{"id_", "e2_id"}).values(new Object[]{1, 2}).values(new Object[]{2, 2}).values(new Object[]{3, 3}).values(new Object[]{4, 3}).exec();
        tester.target("/e2_nested_filter").queryParam("include", new Object[]{"id", "e3s.id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":2,\"e3s\":[{\"id\":1}]}"});
    }

    @Test
    public void filter_InStack() {
        tester.e4().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).exec();
        tester.target("/e4_stack_filter").queryParam("include", new Object[]{"id"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":2}"});
    }

    @Test
    public void filteredPagination1() {
        tester.e4().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).values(new Object[]{3}).values(new Object[]{4}).values(new Object[]{5}).values(new Object[]{6}).values(new Object[]{7}).values(new Object[]{8}).values(new Object[]{9}).values(new Object[]{10}).exec();
        tester.target("/e4_stack_filter").queryParam("include", new Object[]{"id"}).queryParam("sort", new Object[]{"id"}).queryParam("start", new Object[]{"0"}).queryParam("limit", new Object[]{"2"}).get().wasOk().bodyEquals(5L, new String[]{"{\"id\":2},{\"id\":4}"});
    }

    @Test
    public void filteredPagination2() {
        tester.e4().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).values(new Object[]{3}).values(new Object[]{4}).values(new Object[]{5}).values(new Object[]{6}).values(new Object[]{7}).values(new Object[]{8}).values(new Object[]{9}).values(new Object[]{10}).exec();
        tester.target("/e4_stack_filter").queryParam("include", new Object[]{"id"}).queryParam("sort", new Object[]{"id"}).queryParam("start", new Object[]{"2"}).queryParam("limit", new Object[]{"3"}).get().wasOk().bodyEquals(5L, new String[]{"{\"id\":6},{\"id\":8},{\"id\":10}"});
    }

    @Test
    public void filteredPagination3() {
        tester.e4().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).values(new Object[]{3}).values(new Object[]{4}).values(new Object[]{5}).values(new Object[]{6}).values(new Object[]{7}).values(new Object[]{8}).values(new Object[]{9}).values(new Object[]{10}).exec();
        tester.target("/e4_stack_filter").queryParam("include", new Object[]{"id"}).queryParam("sort", new Object[]{"id"}).queryParam("start", new Object[]{"2"}).queryParam("limit", new Object[]{"10"}).get().wasOk().bodyEquals(5L, new String[]{"{\"id\":6},{\"id\":8},{\"id\":10}"});
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e2_nested_filter")
        public DataResponse<E2> getE2(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E2.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e3_nested_filter")
        public DataResponse<E3> getE3(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e4_stack_filter")
        public DataResponse<E4> get(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E4.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e4_by_prop/{cVarchar}")
        public DataResponse<E4> getWithRequestEncoder(@Context UriInfo uriInfo, @PathParam(value="cVarchar") String cVarchar) {
            return AgJaxrs.select(E4.class, (Configuration)this.config).filter(E4.class, e4 -> cVarchar.equals(e4.getCVarchar())).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

