/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E10;
import io.agrest.cayenne.cayenne.main.E11;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class ReadFilter_AnnotationsIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = ReadFilter_AnnotationsIT.tester(Resource.class).entities(E10.class, E11.class).build();

    @Test
    public void annotationReadableFlag_Attributes() {
        tester.e10().insertColumns(new String[]{"id", "c_varchar", "c_int", "c_boolean", "c_date"}).values(new Object[]{1, "xxx", 5, true, "2014-01-02"}).exec();
        tester.target("/e10").get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"cBoolean\":true,\"cInt\":5}"});
    }

    @Test
    public void annotationReadableFlag_Relationship() {
        tester.e10().insertColumns(new String[]{"id", "c_varchar", "c_int", "c_boolean", "c_date"}).values(new Object[]{1, "xxx", 5, true, "2014-01-02"}).exec();
        tester.e11().insertColumns(new String[]{"id", "e10_id", "address", "name"}).values(new Object[]{15, 1, "aaa", "nnn"}).exec();
        tester.target("/e10").queryParam("include", new Object[]{E10.E11S.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"cBoolean\":true,\"cInt\":5,\"e11s\":[{\"address\":\"aaa\"}]}"});
    }

    @Test
    public void readWithInclude_ToManyToOne_MiddleIdNotReadable() {
        tester.e10().insertColumns(new String[]{"id", "c_boolean"}).values(new Object[]{1, true}).exec();
        tester.e11().insertColumns(new String[]{"id", "e10_id"}).values(new Object[]{15, 1}).exec();
        tester.target("e10").queryParam("include", new Object[]{"cBoolean", "e11s.e10.cBoolean"}).get().wasOk().bodyEquals(1L, new String[]{"{\"cBoolean\":true,\"e11s\":[{\"e10\":{\"cBoolean\":true}}]}"});
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e10")
        public DataResponse<E10> get(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E10.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

