/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.SelectStage;
import io.agrest.cayenne.cayenne.main.E14;
import io.agrest.cayenne.cayenne.main.E15;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.jaxrs3.junit.pojo.P7;
import io.agrest.runtime.processor.select.SelectContext;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.Persistent;
import org.junit.jupiter.api.Test;

public class PersistentWithExtraAnnotatedPropertiesIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = PersistentWithExtraAnnotatedPropertiesIT.tester(Resource.class).entitiesAndDependencies(E14.class, E15.class).build();

    @Test
    public void root() {
        tester.e15().insertColumns(new String[]{"long_id", "name"}).values(new Object[]{1L, "xxx"}).exec();
        tester.e14().insertColumns(new String[]{"e15_id", "long_id", "name"}).values(new Object[]{1L, 8L, "yyy"}).exec();
        tester.target("/e14").queryParam("include", new Object[]{"name", "prettyName"}).get().wasOk().bodyEquals(1L, new String[]{"{\"name\":\"yyy\",\"prettyName\":\"yyy_pretty\"}"});
    }

    @Test
    public void includeRelationship() {
        tester.e15().insertColumns(new String[]{"long_id", "name"}).values(new Object[]{1L, "xxx"}).exec();
        tester.e14().insertColumns(new String[]{"e15_id", "long_id", "name"}).values(new Object[]{1L, 8L, "yyy"}).exec();
        tester.target("/e14").queryParam("include", new Object[]{"name", "p7"}).get().wasOk().bodyEquals(1L, new String[]{"{\"name\":\"yyy\",\"p7\":{\"id\":800,\"string\":\"p7_yyy\"}}"});
    }

    @Test
    public void includeRelationshipAttributes() {
        tester.e15().insertColumns(new String[]{"long_id", "name"}).values(new Object[]{1L, "xxx"}).exec();
        tester.e14().insertColumns(new String[]{"e15_id", "long_id", "name"}).values(new Object[]{1L, 8L, "yyy"}).exec();
        tester.target("/e15").queryParam("include", new Object[]{"e14s.name", "e14s.prettyName"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"e14s\":[{\"name\":\"yyy\",\"prettyName\":\"yyy_pretty\"}],\"name\":\"xxx\"}"});
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e15")
        public DataResponse<E15> getE15(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E15.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e14")
        public DataResponse<E14> getE14(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E14.class, (Configuration)this.config).stage(SelectStage.FETCH_DATA, c -> this.afterE14Fetched((SelectContext<E14>)c)).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        void afterE14Fetched(SelectContext<E14> context) {
            for (E14 e14 : context.getEntity().getData()) {
                P7 p7 = new P7();
                p7.setId(Cayenne.intPKForObject((Persistent)e14) * 100);
                p7.setString("p7_" + e14.getName());
                e14.setP7(p7);
            }
        }
    }
}

