/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E20;
import io.agrest.cayenne.cayenne.main.E21;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class NaturalIdIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = NaturalIdIT.tester(Resource.class).entitiesAndDependencies(E20.class, E21.class).build();

    @Test
    public void selectById() {
        tester.e20().insertColumns(new String[]{"name_col"}).values(new Object[]{"John"}).exec();
        tester.target("/single-id/John").queryParam("exclude", new Object[]{"age", "description"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":\"John\",\"name\":\"John\"}"});
        tester.e20().insertColumns(new String[]{"name_col"}).values(new Object[]{"John"}).exec();
        tester.target("/single-id/John").queryParam("exclude", new Object[]{"age", "description"}).get().wasServerError().bodyEquals("{\"message\":\"Found more than one object for ID 'John' and entity 'E20'\"}");
    }

    @Test
    public void selectById_MultiId() {
        tester.e21().insertColumns(new String[]{"age", "name"}).values(new Object[]{18, "John"}).exec();
        tester.target("/multi-id/byid").queryParam("age", new Object[]{18}).queryParam("name", new Object[]{"John"}).queryParam("exclude", new Object[]{"description"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":{\"age\":18,\"name\":\"John\"},\"age\":18,\"name\":\"John\"}"});
        tester.e21().insertColumns(new String[]{"age", "name"}).values(new Object[]{18, "John"}).exec();
        tester.target("/multi-id/byid").queryParam("age", new Object[]{18}).queryParam("name", new Object[]{"John"}).queryParam("exclude", new Object[]{"description"}).get().wasServerError().bodyEquals("{\"message\":\"Found more than one object for ID '{name:John,age:18}' and entity 'E21'\"}");
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="single-id/{id}")
        public DataResponse<E20> getE20ById(@PathParam(value="id") String name, @Context UriInfo uriInfo) {
            return AgJaxrs.select(E20.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).byId((Object)name).get();
        }

        @GET
        @Path(value="multi-id/byid")
        public DataResponse<E21> getE21ById(@QueryParam(value="age") int age, @QueryParam(value="name") String name, @Context UriInfo uriInfo) {
            HashMap<String, Object> id = new HashMap<String, Object>(3);
            id.put("age", age);
            id.put("name", name);
            return AgJaxrs.select(E21.class, (Configuration)this.config).byId(id).clientParams((Map)uriInfo.getQueryParameters()).getOne();
        }
    }
}

