/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class MapByIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = MapByIT.tester(Resource.class).entitiesAndDependencies(E2.class, E3.class, E4.class).build();

    @Test
    public void mapByRootEntity() {
        tester.e4().insertColumns(new String[]{"c_varchar", "c_int"}).values(new Object[]{"xxx", 1}).values(new Object[]{"yyy", 2}).values(new Object[]{"zzz", 2}).exec();
        tester.target("/e4").queryParam("mapBy", new Object[]{"cInt"}).queryParam("include", new Object[]{"cVarchar"}).get().wasOk().bodyEqualsMapBy(3L, new String[]{"\"1\":[{\"cVarchar\":\"xxx\"}]", "\"2\":[{\"cVarchar\":\"yyy\"},{\"cVarchar\":\"zzz\"}]"});
    }

    @Test
    public void mapBy_RelatedId() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "zzz"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "aaa", 1}).values(new Object[]{9, "bbb", 1}).values(new Object[]{10, "ccc", 2}).exec();
        tester.target("/e3").queryParam("mapBy", new Object[]{"e2.id"}).queryParam("exclude", new Object[]{"phoneNumber"}).get().wasOk().bodyEqualsMapBy(3L, new String[]{"\"1\":[{\"id\":8,\"name\":\"aaa\"},{\"id\":9,\"name\":\"bbb\"}]", "\"2\":[{\"id\":10,\"name\":\"ccc\"}]"});
    }

    @Test
    public void mapBy_OverRelationship() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "zzz"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "aaa", 1}).values(new Object[]{9, "bbb", 1}).values(new Object[]{10, "ccc", 2}).exec();
        tester.target("/e3").queryParam("mapBy", new Object[]{"e2"}).queryParam("exclude", new Object[]{"phoneNumber"}).get().wasOk().bodyEqualsMapBy(3L, new String[]{"\"1\":[{\"id\":8,\"name\":\"aaa\"},{\"id\":9,\"name\":\"bbb\"}]", "\"2\":[{\"id\":10,\"name\":\"ccc\"}]"});
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e3")
        public DataResponse<E3> getE3(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e4")
        public DataResponse<E4> getE4(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E4.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

