/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.inheritance.Ie1Sub1;
import io.agrest.cayenne.cayenne.inheritance.Ie1Super;
import io.agrest.cayenne.cayenne.inheritance.Ie2;
import io.agrest.cayenne.cayenne.inheritance.Ie3;
import io.agrest.cayenne.unit.inheritance.InheritanceDbTest;
import io.agrest.cayenne.unit.inheritance.InheritanceModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class InheritanceIT
extends InheritanceDbTest {
    @BQTestTool
    static final InheritanceModelTester tester = InheritanceIT.tester(Resource.class).entities(Ie1Super.class, Ie2.class, Ie3.class).build();

    @Test
    public void superclass() {
        tester.ie1().insertColumns(new String[]{"id", "type", "a0", "a1", "a2", "a3"}).values(new Object[]{10, 1, "v01", "v11", null, null}).values(new Object[]{20, 2, "v02", null, "v21", null}).values(new Object[]{30, 3, "v03", "v13", null, "v31"}).exec();
        tester.target("/ie1-super").get().wasOk().bodyEquals(3L, new String[]{"{\"id\":10,\"a0\":\"v01\",\"a1\":\"v11\",\"type\":1}", "{\"id\":20,\"a0\":\"v02\",\"a2\":\"v21\",\"type\":2}", "{\"id\":30,\"a0\":\"v03\",\"a1\":\"v13\",\"a3\":\"v31\",\"type\":3}"});
    }

    @Test
    public void superclass_Includes() {
        tester.ie1().insertColumns(new String[]{"id", "type", "a0", "a1", "a2", "a3"}).values(new Object[]{10, 1, "v01", "v11", null, null}).values(new Object[]{20, 2, "v02", null, "v21", null}).values(new Object[]{30, 3, "v03", "v13", null, "v31"}).exec();
        tester.target("/ie1-super").queryParam("include", new Object[]{"id", "a0", "a1", "a3"}).get().wasOk().bodyEquals(3L, new String[]{"{\"id\":10,\"a0\":\"v01\",\"a1\":\"v11\"}", "{\"id\":20,\"a0\":\"v02\"}", "{\"id\":30,\"a0\":\"v03\",\"a1\":\"v13\",\"a3\":\"v31\"}"});
    }

    @Test
    public void superclass_Includes_Relationships() {
        tester.ie2().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).exec();
        tester.ie1().insertColumns(new String[]{"id", "type", "e2_id"}).values(new Object[]{10, 1, 2}).values(new Object[]{20, 2, null}).exec();
        tester.ie3().insertColumns(new String[]{"id", "e1_id"}).values(new Object[]{1, 10}).values(new Object[]{2, 20}).exec();
        tester.target("/ie1-super").queryParam("include", new Object[]{"id", "ie2", "ie3s"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":10,\"ie2\":{\"id\":2},\"ie3s\":[{\"id\":1}]}", "{\"id\":20,\"ie3s\":[{\"id\":2}]}"});
    }

    @Test
    public void superclass_Excludes() {
        tester.ie1().insertColumns(new String[]{"id", "type", "a0", "a1", "a2", "a3"}).values(new Object[]{10, 1, "v01", "v11", null, null}).values(new Object[]{20, 2, "v02", null, "v21", null}).values(new Object[]{30, 3, "v03", "v13", null, "v31"}).exec();
        tester.target("/ie1-super").queryParam("exclude", new Object[]{"a0", "a1", "a3"}).get().wasOk().bodyEquals(3L, new String[]{"{\"id\":10,\"type\":1}", "{\"id\":20,\"a2\":\"v21\",\"type\":2}", "{\"id\":30,\"type\":3}"});
    }

    @Test
    public void subclass() {
        tester.ie1().insertColumns(new String[]{"id", "type", "a0", "a1", "a2"}).values(new Object[]{10, 1, "v01", "v11", null}).values(new Object[]{20, 2, "v02", null, "v21"}).exec();
        tester.target("/ie1-sub1").get().wasOk().bodyEquals(1L, new String[]{"{\"id\":10,\"a0\":\"v01\",\"a1\":\"v11\",\"type\":1}"});
    }

    @Test
    public void relatedSuperclass() {
        tester.ie1().insertColumns(new String[]{"id", "type", "a0", "a1", "a2", "a3"}).values(new Object[]{10, 1, "v01", "v11", null, null}).values(new Object[]{20, 2, "v02", null, "v21", null}).values(new Object[]{30, 3, "v03", "v13", null, "v31"}).exec();
        tester.ie3().insertColumns(new String[]{"id", "e1_id"}).values(new Object[]{1, 10}).values(new Object[]{2, 20}).values(new Object[]{3, 30}).exec();
        tester.target("/ie3").queryParam("include", new Object[]{"id", "ie1"}).get().wasOk().bodyEquals(3L, new String[]{"{\"id\":1,\"ie1\":{\"id\":10,\"a0\":\"v01\",\"a1\":\"v11\",\"type\":1}}", "{\"id\":2,\"ie1\":{\"id\":20,\"a0\":\"v02\",\"a2\":\"v21\",\"type\":2}}", "{\"id\":3,\"ie1\":{\"id\":30,\"a0\":\"v03\",\"a1\":\"v13\",\"a3\":\"v31\",\"type\":3}}"});
    }

    @Test
    public void relatedSuperclass_IncludeRelationships() {
        tester.ie2().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).exec();
        tester.ie1().insertColumns(new String[]{"id", "type", "a0", "a1", "a2", "a3", "e2_id"}).values(new Object[]{10, 1, "v01", "v11", null, null, 2}).values(new Object[]{20, 2, "v02", null, "v21", null, null}).values(new Object[]{30, 3, "v03", "v13", null, "v31", 1}).exec();
        tester.ie3().insertColumns(new String[]{"id", "e1_id"}).values(new Object[]{1, 10}).values(new Object[]{2, 20}).values(new Object[]{3, 30}).exec();
        tester.target("/ie3").queryParam("include", new Object[]{"id", "ie1.type", "ie1.ie2.id", "ie1.ie3s.id"}).queryParam("exp", new Object[]{"id > 0"}).get().wasOk().bodyEquals(3L, new String[]{"{\"id\":1,\"ie1\":{\"ie2\":{\"id\":2},\"ie3s\":[{\"id\":1}],\"type\":1}}", "{\"id\":2,\"ie1\":{\"ie3s\":[{\"id\":2}],\"type\":2}}", "{\"id\":3,\"ie1\":{\"ie2\":{\"id\":1},\"ie3s\":[{\"id\":3}],\"type\":3}}"});
    }

    @Test
    public void relatedSubclass() {
        tester.ie2().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).exec();
        tester.ie1().insertColumns(new String[]{"id", "type", "a0", "a1", "a2", "e2_id"}).values(new Object[]{10, 1, "v01", "v10", null, 1}).values(new Object[]{15, 1, "v02", "v15", null, 2}).values(new Object[]{20, 2, "v03", null, "v2", null}).exec();
        tester.target("/ie2").queryParam("include", new Object[]{"id", "ie1s"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"ie1s\":[{\"id\":10,\"a0\":\"v01\",\"a1\":\"v10\",\"type\":1}]}", "{\"id\":2,\"ie1s\":[{\"id\":15,\"a0\":\"v02\",\"a1\":\"v15\",\"type\":1}]}"});
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="ie1-super")
        public DataResponse<Ie1Super> getIe1Super(@Context UriInfo uriInfo) {
            return AgJaxrs.select(Ie1Super.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="ie1-sub1")
        public DataResponse<Ie1Sub1> getIe1Sub1(@Context UriInfo uriInfo) {
            return AgJaxrs.select(Ie1Sub1.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="ie2")
        public DataResponse<Ie2> getIE2(@Context UriInfo uriInfo) {
            return AgJaxrs.select(Ie2.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="ie3")
        public DataResponse<Ie3> getIE3(@Context UriInfo uriInfo) {
            return AgJaxrs.select(Ie3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

