/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.SelectBuilder;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E5;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Include_MaxPathDepthIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = Include_MaxPathDepthIT.tester(Resource.class).entitiesAndDependencies(E2.class, E3.class, E5.class).build();

    @BeforeEach
    void insertTestData() {
        tester.e5().insertColumns(new String[]{"id", "name", "date"}).values(new Object[]{45, "T", "2013-01-03"}).exec();
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{8, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id", "e5_id"}).values(new Object[]{3, "zzz", 8, 45}).exec();
    }

    @Test
    public void depth100_Default() {
        tester.target("/e2").queryParam("include", new Object[]{"id", "e3s.id", "e3s.e5.id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":8,\"e3s\":[{\"id\":3,\"e5\":{\"id\":45}}]}"});
    }

    @Test
    public void depth0_DefaultIncludes() {
        tester.target("/e2").queryParam("depth", new Object[]{0}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":8,\"address\":null,\"name\":\"yyy\"}"});
    }

    @Test
    public void depth0() {
        tester.target("/e2").queryParam("depth", new Object[]{0}).queryParam("include", new Object[]{"id", "e3s.id", "e3s.e5.id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":8}"});
    }

    @Test
    public void depth1() {
        tester.target("/e2").queryParam("depth", new Object[]{1}).queryParam("include", new Object[]{"id", "e3s.id", "e3s.e5.id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":8,\"e3s\":[{\"id\":3}]}"});
    }

    @Test
    public void depth2() {
        tester.target("/e2").queryParam("depth", new Object[]{2}).queryParam("include", new Object[]{"id", "e3s.id", "e3s.e5.id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":8,\"e3s\":[{\"id\":3,\"e5\":{\"id\":45}}]}"});
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e2")
        public DataResponse<E2> getE2(@Context UriInfo uriInfo, @QueryParam(value="depth") Integer depth) {
            SelectBuilder builder = AgJaxrs.select(E2.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters());
            if (depth != null) {
                builder.maxPathDepth(depth.intValue());
            }
            return builder.get();
        }
    }
}

