/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E15;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E5;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class IncludeIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = IncludeIT.tester(Resource.class).entitiesAndDependencies(E2.class, E3.class, E5.class, E15.class).build();

    @Test
    public void related() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", 1}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id", "e2.id"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":8,\"e2\":{\"id\":1}}", "{\"id\":9,\"e2\":{\"id\":1}}"});
        tester.assertQueryCount(2);
    }

    @Test
    public void orderOfInclude() {
        tester.e5().insertColumns(new String[]{"id", "name", "date"}).values(new Object[]{45, "T", "2013-01-03"}).exec();
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{8, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id", "e5_id"}).values(new Object[]{3, "zzz", 8, 45}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id", "e2", "e2.id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":3,\"e2\":{\"id\":8}}"});
        tester.assertQueryCount(2);
        tester.target("/e3").queryParam("include", new Object[]{"id", "e2.id", "e2"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":3,\"e2\":{\"id\":8}}"});
        tester.assertQueryCount(4);
    }

    @Test
    public void phantom() {
        tester.e5().insertColumns(new String[]{"id", "name", "date"}).values(new Object[]{45, "T", "2013-01-03"}).exec();
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{8, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id", "e5_id"}).values(new Object[]{3, "zzz", 8, 45}).exec();
        tester.target("/e2").queryParam("include", new Object[]{"id", "e3s.e5.id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":8,\"e3s\":[{\"e5\":{\"id\":45}}]}"});
        tester.assertQueryCount(3);
    }

    @Test
    public void phantom_OverExplicitJoinTable() {
        tester.e1().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e15().insertColumns(new String[]{"long_id", "name"}).values(new Object[]{14L, "aaa"}).values(new Object[]{15L, "bbb"}).values(new Object[]{16L, "ccc"}).exec();
        tester.e15_1().insertColumns(new String[]{"e15_id", "e1_id"}).values(new Object[]{14, 1}).exec();
        tester.target("/e15").queryParam("include", new Object[]{"id", "e15e1.e1"}).get().wasOk().bodyEquals(3L, new String[]{"{\"id\":14,\"e15e1\":[{\"e1\":{\"id\":1,\"age\":null,\"description\":null,\"name\":\"xxx\"}}]}", "{\"id\":15,\"e15e1\":[]}", "{\"id\":16,\"e15e1\":[]}"});
        tester.assertQueryCount(3);
    }

    @Test
    public void startLimit() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", 1}).values(new Object[]{10, "zzz", 1}).values(new Object[]{11, "zzz", 1}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id", "e2.id"}).queryParam("sort", new Object[]{"id"}).queryParam("start", new Object[]{"2"}).queryParam("limit", new Object[]{"2"}).get().wasOk().bodyEquals(4L, new String[]{"{\"id\":10,\"e2\":{\"id\":1}}", "{\"id\":11,\"e2\":{\"id\":1}}"});
        tester.assertQueryCount(2);
        tester.target("/e3").queryParam("include", new Object[]{"id", "e2.id"}).queryParam("sort", new Object[]{"id"}).queryParam("start", new Object[]{"1"}).queryParam("limit", new Object[]{"2"}).get().wasOk().bodyEquals(4L, new String[]{"{\"id\":9,\"e2\":{\"id\":1}}", "{\"id\":10,\"e2\":{\"id\":1}}"});
        tester.assertQueryCount(5);
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e2")
        public DataResponse<E2> getE2(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E2.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e3")
        public DataResponse<E3> getE3(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e15")
        public DataResponse<E15> getE15(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E15.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

