/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E23;
import io.agrest.cayenne.cayenne.main.E26;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class ExposedIdIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = ExposedIdIT.tester(Resource.class).entities(E23.class, E26.class).build();

    @Test
    public void byId() {
        tester.e23().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "abc"}).values(new Object[]{2, "xyz"}).exec();
        tester.target("/e23/1").get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"exposedId\":1,\"name\":\"abc\"}"});
    }

    @Test
    public void includeFrom() {
        tester.e23().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "abc"}).exec();
        tester.e26().insertColumns(new String[]{"id", "e23_id"}).values(new Object[]{41, 1}).exec();
        tester.target("/e23").queryParam("include", new Object[]{"id", "e26s.id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"e26s\":[{\"id\":41}]}"});
        tester.assertQueryCount(2);
    }

    @Test
    public void includeTo() {
        tester.e23().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "abc"}).exec();
        tester.e26().insertColumns(new String[]{"id", "e23_id"}).values(new Object[]{41, 1}).exec();
        tester.target("/e26").queryParam("include", new Object[]{"id", "e23.id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":41,\"e23\":{\"id\":1}}"});
        tester.assertQueryCount(2);
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e26")
        public DataResponse<E26> getAllE26s(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E26.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).getOne();
        }

        @GET
        @Path(value="e23")
        public DataResponse<E23> getAllE23s(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E23.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).getOne();
        }

        @GET
        @Path(value="e23/{id}")
        public DataResponse<E23> getById(@PathParam(value="id") int id, @Context UriInfo uriInfo) {
            return AgJaxrs.select(E23.class, (Configuration)this.config).byId((Object)id).clientParams((Map)uriInfo.getQueryParameters()).getOne();
        }
    }
}

