/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.AgRequest;
import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import java.sql.Date;
import java.time.LocalDate;
import org.junit.jupiter.api.Test;

public class Exp_PropFilter_Overlay_RequestIT
extends MainDbTest {
    @BQTestTool
    final MainModelTester tester = Exp_PropFilter_Overlay_RequestIT.tester(Resource.class).entitiesAndDependencies(E2.class).build();

    @Test
    public void noNameThanName() {
        this.tester.e2().insertColumns(new String[]{"id_", "name", "address"}).values(new Object[]{1, "n1", "a1"}).values(new Object[]{2, "n2", "a2"}).exec();
        this.tester.target("e2-sans-name").queryParam("exp", new Object[]{"name = 'n1'"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"address\":\"a1\"}"});
        this.tester.target("e2-all").queryParam("exp", new Object[]{"name = 'n1'"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"address\":\"a1\",\"name\":\"n1\"}"});
    }

    @Test
    public void nameAsDateThenAsString() {
        this.tester.e2().insertColumns(new String[]{"id_", "name", "address"}).values(new Object[]{1, "2021-01-01", "a1"}).values(new Object[]{2, "2021-01-02", "a2"}).exec();
        this.tester.target("e2-name-as-date").queryParam("exp", new Object[]{"name = '2021-01-01'"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"address\":\"a1\",\"name\":\"2021-01-01\"}"});
        this.tester.target("e2-all").queryParam("exp", new Object[]{"name = '2021-01-01'"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"address\":\"a1\",\"name\":\"2021-01-01\"}"});
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e2-all")
        public DataResponse<E2> all(@QueryParam(value="exp") String exp) {
            AgRequest request = AgJaxrs.request((Configuration)this.config).andExp(exp).build();
            return AgJaxrs.select(E2.class, (Configuration)this.config).request(request).get();
        }

        @GET
        @Path(value="e2-sans-name")
        public DataResponse<E2> sansName(@QueryParam(value="exp") String exp) {
            AgRequest request = AgJaxrs.request((Configuration)this.config).andExp(exp).build();
            return AgJaxrs.select(E2.class, (Configuration)this.config).request(request).propFilter(E2.class, b -> b.property("name", false)).get();
        }

        @GET
        @Path(value="e2-name-as-date")
        public DataResponse<E2> nameAsDate(@QueryParam(value="exp") String exp) {
            AgRequest request = AgJaxrs.request((Configuration)this.config).andExp(exp).build();
            return AgJaxrs.select(E2.class, (Configuration)this.config).request(request).entityOverlay(AgEntity.overlay(E2.class).attribute("name", Date.class, e2 -> Date.valueOf(LocalDate.parse(e2.getName())))).get();
        }
    }
}

