/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E22;
import io.agrest.cayenne.cayenne.main.E25;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.agrest.runtime.AgRuntimeBuilder;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.query.SelectById;
import org.junit.jupiter.api.Test;

public class EntityOverlay_PerStackIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = EntityOverlay_PerStackIT.tester(Resource.class).entities(E22.class, E25.class, E2.class, E3.class).agCustomizer(EntityOverlay_PerStackIT::addOverlay).build();

    private static AgRuntimeBuilder addOverlay(AgRuntimeBuilder builder) {
        AgEntityOverlay e22Overlay = AgEntity.overlay(E22.class).toOne("overlayToOne", E25.class, EntityOverlay_PerStackIT::findForParent);
        AgEntityOverlay e2Overlay = AgEntity.overlay(E2.class).readablePropFilter(p -> p.property("id_", false));
        return builder.entityOverlay(e22Overlay).entityOverlay(e2Overlay);
    }

    private static E25 findForParent(E22 parent) {
        return (E25)((Object)SelectById.query(E25.class, (Object)(Cayenne.intPKForObject((Persistent)parent) * 2)).selectOne(parent.getObjectContext()));
    }

    @Test
    public void redefineToOne() {
        tester.e22().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).exec();
        tester.e25().insertColumns(new String[]{"id"}).values(new Object[]{1}).values(new Object[]{2}).values(new Object[]{3}).values(new Object[]{4}).exec();
        tester.target("/e22").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"overlayToOne"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"overlayToOne\":{\"id\":2}}", "{\"id\":2,\"overlayToOne\":{\"id\":4}}"});
    }

    @Test
    public void overlay_HidingId() {
        tester.e2().insertColumns(new String[]{"id_", "name", "address"}).values(new Object[]{1, "N", "A"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "phone_number", "e2_id"}).values(new Object[]{4, "N", "P", 1}).exec();
        tester.target("e2/noid").queryParam("include", new Object[]{"name", "e3s.id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"e3s\":[{\"id\":4}],\"name\":\"N\"}"});
    }

    @Path(value="")
    public static final class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e22")
        public DataResponse<E22> getE22(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E22.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e2/noid")
        public DataResponse<E2> getE2_NoId(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E2.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

