/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E10;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E22;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import java.util.function.Function;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.query.SelectById;
import org.junit.jupiter.api.Test;

public class EntityOverlay_PerRequestIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = EntityOverlay_PerRequestIT.tester(Resource.class).entities(E2.class, E3.class, E4.class, E22.class).entitiesAndDependencies(E10.class).build();

    @Test
    public void defaultIncludes() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{2, "a"}).values(new Object[]{4, "b"}).exec();
        tester.target("/e4/xyz").queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":2,\"cBoolean\":null,\"cDate\":null,\"cDecimal\":null,\"cInt\":null,\"cTime\":null,\"cTimestamp\":null,\"cVarchar\":\"a_x\",\"fromRequest\":\"xyz\",\"objectProperty\":\"a$\"},{\"id\":4,\"cBoolean\":null,\"cDate\":null,\"cDecimal\":null,\"cInt\":null,\"cTime\":null,\"cTimestamp\":null,\"cVarchar\":\"b_x\",\"fromRequest\":\"xyz\",\"objectProperty\":\"b$\"}"});
    }

    @Test
    public void includes() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{2, "a"}).values(new Object[]{4, "b"}).exec();
        tester.target("/e4/xyz").queryParam("sort", new Object[]{"id"}).queryParam("include", new Object[]{"[\"id\",\"cVarchar\",\"fromRequest\"]"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":2,\"cVarchar\":\"a_x\",\"fromRequest\":\"xyz\"},{\"id\":4,\"cVarchar\":\"b_x\",\"fromRequest\":\"xyz\"}"});
    }

    @Test
    public void overlay_NoReaderCaching() {
        tester.e4().insertColumns(new String[]{"id"}).values(new Object[]{2}).values(new Object[]{4}).exec();
        tester.target("/e4/xyz").queryParam("sort", new Object[]{"id"}).queryParam("include", new Object[]{"fromRequest"}).get().wasOk().bodyEquals(2L, new String[]{"{\"fromRequest\":\"xyz\"},{\"fromRequest\":\"xyz\"}"});
        tester.target("/e4/abc").queryParam("sort", new Object[]{"id"}).queryParam("include", new Object[]{"fromRequest"}).get().wasOk().bodyEquals(2L, new String[]{"{\"fromRequest\":\"abc\"},{\"fromRequest\":\"abc\"}"});
    }

    @Test
    public void requestOverlaidProperties_ConstrainedEntity() {
        tester.e10().insertColumns(new String[]{"id", "c_int"}).values(new Object[]{2, 5}).values(new Object[]{4, 8}).exec();
        tester.e22().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "a"}).values(new Object[]{2, "b"}).values(new Object[]{3, "c"}).exec();
        tester.target("/e10/xyz").queryParam("include", new Object[]{"[\"id\",\"cInt\",\"fromRequest\",\"dynamicRelationship\"]"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":2,\"cInt\":6,\"dynamicRelationship\":{\"id\":2,\"name\":\"b\",\"prop1\":null,\"prop2\":null},\"fromRequest\":\"xyz\"},{\"id\":4,\"cInt\":9,\"dynamicRelationship\":null,\"fromRequest\":\"xyz\"}"});
    }

    @Test
    public void overlaidRelationship() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{2, "a"}).values(new Object[]{4, "b"}).exec();
        tester.e22().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "a"}).values(new Object[]{2, "b"}).values(new Object[]{3, "c"}).exec();
        tester.target("/e4/xyz").queryParam("include", new Object[]{"[\"id\",\"cVarchar\",\"fromRequest\",\"dynamicRelationship\"]"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":2,\"cVarchar\":\"a_x\",\"dynamicRelationship\":{\"id\":2,\"name\":\"b\",\"prop1\":null,\"prop2\":null},\"fromRequest\":\"xyz\"},{\"id\":4,\"cVarchar\":\"b_x\",\"dynamicRelationship\":null,\"fromRequest\":\"xyz\"}"});
    }

    @Test
    public void overlaidRelationship_ExpOnParent() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{2, "a"}).values(new Object[]{4, "b"}).exec();
        tester.e22().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "a"}).values(new Object[]{2, "b"}).values(new Object[]{3, "c"}).exec();
        tester.target("/e4/xyz").queryParam("exp", new Object[]{"id = 2"}).queryParam("include", new Object[]{"[\"id\",\"dynamicRelationship\"]"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":2,\"dynamicRelationship\":{\"id\":2,\"name\":\"b\",\"prop1\":null,\"prop2\":null}}"});
    }

    @Test
    public void overlaidRelationship_ExpOnParent_RelatedToOne() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{2, "a"}).values(new Object[]{4, "b"}).exec();
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "a2"}).values(new Object[]{2, "b2"}).values(new Object[]{3, "c2"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{1, "a", 1}).values(new Object[]{2, "b", 1}).values(new Object[]{3, "c", 1}).exec();
        tester.target("/e4_2").queryParam("exp", new Object[]{"id = 2"}).queryParam("include", new Object[]{"[\"id\",\"dynamicRelationship.e2\"]"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":2,\"dynamicRelationship\":{\"e2\":{\"id\":1,\"address\":null,\"name\":\"a2\"}}}"});
    }

    @Test
    public void overlaidRelatedExclude() {
        tester.e2().insertColumns(new String[]{"id_", "name", "address"}).values(new Object[]{1, "N", "A"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "phone_number", "e2_id"}).values(new Object[]{1, "N", "P", 1}).exec();
        tester.target("/e2").queryParam("include", new Object[]{"e3s"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"e3s\":[{\"id\":1,\"name\":\"N\"}],\"name\":\"N\"}"});
    }

    @Test
    public void overlaidExclude() {
        tester.e2().insertColumns(new String[]{"id_", "name", "address"}).values(new Object[]{1, "N", "A"}).exec();
        tester.target("/e2").get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"name\":\"N\"}"});
    }

    @Test
    public void overlaidDataReaderException() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{2, "a"}).values(new Object[]{4, "b"}).exec();
        tester.target("/e4_with_exception").get().wasServerError();
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        private static <T extends Persistent> T findMatching(Class<T> type, Persistent p) {
            return (T)((Persistent)SelectById.query(type, (Object)Cayenne.pkForObject((Persistent)p)).selectOne(p.getObjectContext()));
        }

        @GET
        @Path(value="e10/{suffix}")
        public DataResponse<E10> getE10(@Context UriInfo uriInfo, @PathParam(value="suffix") String suffix) {
            AgEntityOverlay overlay = AgEntity.overlay(E10.class).attribute("fromRequest", String.class, e4 -> suffix).attribute("cInt", Integer.class, e10 -> e10.getCInt() + 1).toOne("dynamicRelationship", E22.class, e10 -> Resource.findMatching(E22.class, (Persistent)e10));
            return AgJaxrs.select(E10.class, (Configuration)this.config).entityOverlay(overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e4/{suffix}")
        public DataResponse<E4> getE4(@Context UriInfo uriInfo, @PathParam(value="suffix") String suffix) {
            AgEntityOverlay overlay = AgEntity.overlay(E4.class).attribute("fromRequest", String.class, e4 -> suffix).attribute("objectProperty", String.class, E4::getDerived).attribute("cVarchar", String.class, e4 -> e4.getCVarchar() + "_x").toOne("dynamicRelationship", E22.class, e4 -> Resource.findMatching(E22.class, (Persistent)e4));
            return AgJaxrs.select(E4.class, (Configuration)this.config).entityOverlay(overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e4_2")
        public DataResponse<E4> getE4_WithE3(@Context UriInfo uriInfo) {
            AgEntityOverlay overlay = AgEntity.overlay(E4.class).toOne("dynamicRelationship", E3.class, e4 -> Resource.findMatching(E3.class, (Persistent)e4));
            return AgJaxrs.select(E4.class, (Configuration)this.config).entityOverlay(overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e2")
        public DataResponse<E2> getE2_With_exclude(@Context UriInfo uriInfo) {
            AgEntityOverlay e2Overlay = AgEntity.overlay(E2.class).readablePropFilter(p -> p.property("address", false));
            AgEntityOverlay e3Overlay = AgEntity.overlay(E3.class).readablePropFilter(p -> p.property("phoneNumber", false));
            return AgJaxrs.select(E2.class, (Configuration)this.config).entityOverlay(e2Overlay).entityOverlay(e3Overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e4_with_exception")
        public DataResponse<E4> getE4_withException(@Context UriInfo uriInfo) {
            Function<E4, String> throwing = e4 -> {
                throw new RuntimeException("testing this exception");
            };
            AgEntityOverlay overlay = AgEntity.overlay(E4.class).attribute("ax", String.class, throwing);
            return AgJaxrs.select(E4.class, (Configuration)this.config).entityOverlay(overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

