/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.annotation.AgAttribute;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.cayenne.main.E7;
import io.agrest.cayenne.cayenne.main.E8;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.agrest.runtime.AgRuntimeBuilder;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.junit.jupiter.api.Test;

public class EntityOverlayIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = EntityOverlayIT.tester(Resource.class).entitiesAndDependencies(E2.class, E3.class, E4.class, E7.class, E8.class).agCustomizer(EntityOverlayIT::addOverlay).build();

    private static AgRuntimeBuilder addOverlay(AgRuntimeBuilder builder) {
        AgEntityOverlay e2Overlay = AgEntity.overlay(E2.class).attribute("adhocString", String.class, e2 -> e2.getName() + "*").readablePropFilter(p -> p.property("address", false));
        AgEntityOverlay e4Overlay = AgEntity.overlay(E4.class).attribute("adhocString", String.class, e4 -> e4.getCVarchar() + "*").toOne("adhocToOne", EX.class, EX::forE4).toMany("adhocToMany", EY.class, EY::forE4).attribute("derived", String.class, E4::getDerived);
        AgEntityOverlay e7Overlay = AgEntity.overlay(E7.class).relatedDataResolver("e8", e7 -> {
            E8 e8 = new E8();
            e8.setObjectId(ObjectId.of((String)"e8", (String)"id", (Object)Cayenne.intPKForObject((Persistent)e7)));
            e8.setName(e7.getName() + "_e8");
            return e8;
        }).attribute("name", Integer.class, e7 -> e7.getName().length());
        return builder.entityOverlay(e4Overlay).entityOverlay(e2Overlay).entityOverlay(e7Overlay);
    }

    @Test
    public void exclude() {
        tester.e2().insertColumns(new String[]{"id_", "name", "address"}).values(new Object[]{1, "N", "A"}).exec();
        tester.target("/e2").get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1,\"adhocString\":\"N*\",\"name\":\"N\"}"});
    }

    @Test
    public void redefineAttribute_Transient() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{1, "x"}).values(new Object[]{2, "y"}).exec();
        tester.target("/e4").queryParam("include", new Object[]{"derived"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"derived\":\"x$\"},{\"derived\":\"y$\"}"});
    }

    @Test
    public void redefineAttribute_AdHocRelated() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{3, "zzz", 1}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"e2.adhocString"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":3,\"e2\":{\"adhocString\":\"xxx*\"}}"});
    }

    @Test
    public void redefineAttribute_AdHoc() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{1, "x"}).values(new Object[]{2, "y"}).exec();
        tester.target("/e4").queryParam("include", new Object[]{"adhocString"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"adhocString\":\"x*\"},{\"adhocString\":\"y*\"}"});
    }

    @Test
    public void redefineToOne_AdHoc() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{1, "x"}).values(new Object[]{2, "y"}).exec();
        tester.target("/e4").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"adhocToOne"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"adhocToOne\":{\"p1\":\"x_\"}}", "{\"id\":2,\"adhocToOne\":{\"p1\":\"y_\"}}"});
    }

    @Test
    public void redefineToMany_AdHoc() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{1, "x"}).values(new Object[]{2, "y"}).exec();
        tester.target("/e4").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"adhocToMany"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"adhocToMany\":[{\"p1\":\"x-\"},{\"p1\":\"x%\"}]}", "{\"id\":2,\"adhocToMany\":[{\"p1\":\"y-\"},{\"p1\":\"y%\"}]}"});
    }

    @Test
    public void redefineToOne_Replaced() {
        tester.e7().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "x1"}).values(new Object[]{2, "x2"}).exec();
        tester.target("/e7").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"e8.name"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"e8\":{\"name\":\"x1_e8\"}}", "{\"id\":2,\"e8\":{\"name\":\"x2_e8\"}}"});
    }

    @Test
    public void redefineAttribute_Replaced() {
        tester.e7().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "01"}).values(new Object[]{2, "0123"}).exec();
        tester.target("/e7").queryParam("include", new Object[]{"id"}).queryParam("include", new Object[]{"name"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"id\":1,\"name\":2}", "{\"id\":2,\"name\":4}"});
    }

    public static final class EX {
        private final String p1;

        public EX(String p1) {
            this.p1 = p1;
        }

        static EX forE4(E4 e4) {
            return new EX(e4.getCVarchar() + "_");
        }

        @AgAttribute
        public String getP1() {
            return this.p1;
        }
    }

    public static final class EY {
        private final String p1;

        public EY(String p1) {
            this.p1 = p1;
        }

        static List<EY> forE4(E4 e4) {
            return Arrays.asList(new EY(e4.getCVarchar() + "-"), new EY(e4.getCVarchar() + "%"));
        }

        @AgAttribute
        public String getP1() {
            return this.p1;
        }
    }

    @Path(value="")
    public static final class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e2")
        public DataResponse<E2> getE2(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E2.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e3")
        public DataResponse<E3> getE3(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e4")
        public DataResponse<E4> getE4(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E4.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e7")
        public DataResponse<E7> getE7(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E7.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

