/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.SelectBuilder;
import io.agrest.SelectStage;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.runtime.DefaultSelectBuilder;
import io.bootique.junit5.BQTestTool;
import java.util.EnumMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultSelectBuilder_CustomPipelineIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = DefaultSelectBuilder_CustomPipelineIT.tester(new Class[0]).build();

    private <T> DefaultSelectBuilder<T> createBuilder(Class<T> type) {
        SelectBuilder builder = tester.runtime().select(type);
        Assertions.assertTrue((boolean)(builder instanceof DefaultSelectBuilder));
        return (DefaultSelectBuilder)builder;
    }

    @Test
    public void stage_AllStages() {
        EnumMap<SelectStage, Integer> stages = new EnumMap<SelectStage, Integer>(SelectStage.class);
        Consumer<SelectStage> stageRecorder = s -> stages.put((SelectStage)s, stages.size());
        this.createBuilder(E2.class).stage(SelectStage.CREATE_ENTITY, c -> stageRecorder.accept(SelectStage.CREATE_ENTITY)).stage(SelectStage.START, c -> stageRecorder.accept(SelectStage.START)).stage(SelectStage.FETCH_DATA, c -> stageRecorder.accept(SelectStage.FETCH_DATA)).stage(SelectStage.FILTER_RESULT, c -> stageRecorder.accept(SelectStage.FILTER_RESULT)).stage(SelectStage.ENCODE, c -> stageRecorder.accept(SelectStage.ENCODE)).stage(SelectStage.ASSEMBLE_QUERY, c -> stageRecorder.accept(SelectStage.ASSEMBLE_QUERY)).stage(SelectStage.APPLY_SERVER_PARAMS, c -> stageRecorder.accept(SelectStage.APPLY_SERVER_PARAMS)).get();
        Assertions.assertEquals((int)SelectStage.values().length, (int)stages.size());
        stages.forEach((k, v) -> Assertions.assertEquals((int)k.ordinal(), (int)v));
    }

    @Test
    public void stage_Composition() {
        EnumMap stages = new EnumMap(SelectStage.class);
        BiConsumer<SelectStage, String> stageRecorder = (stage, value) -> {
            String existing = stages.computeIfAbsent((SelectStage)stage, a -> "");
            stages.put((SelectStage)stage, existing + "_" + value);
        };
        this.createBuilder(E2.class).stage(SelectStage.APPLY_SERVER_PARAMS, c -> stageRecorder.accept(SelectStage.APPLY_SERVER_PARAMS, "a")).stage(SelectStage.FETCH_DATA, c -> stageRecorder.accept(SelectStage.FETCH_DATA, "b")).stage(SelectStage.APPLY_SERVER_PARAMS, c -> stageRecorder.accept(SelectStage.APPLY_SERVER_PARAMS, "c")).stage(SelectStage.APPLY_SERVER_PARAMS, c -> stageRecorder.accept(SelectStage.APPLY_SERVER_PARAMS, "d")).stage(SelectStage.FETCH_DATA, c -> stageRecorder.accept(SelectStage.FETCH_DATA, "e")).stage(SelectStage.ENCODE, c -> stageRecorder.accept(SelectStage.ENCODE, "f")).get();
        Assertions.assertEquals((int)3, (int)stages.size());
        Assertions.assertEquals((Object)"_a_c_d", stages.get(SelectStage.APPLY_SERVER_PARAMS));
        Assertions.assertEquals((Object)"_b_e", stages.get(SelectStage.FETCH_DATA));
        Assertions.assertEquals((Object)"_f", stages.get(SelectStage.ENCODE));
    }
}

