/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E19;
import io.agrest.cayenne.cayenne.main.E28;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class ConvertersIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = ConvertersIT.tester(Resource.class).entities(E4.class, E19.class, E28.class).build();

    @Test
    public void timestampAsUtilDate() {
        LocalDateTime dateTime = LocalDateTime.of(2012, 2, 3, 11, 1, 2);
        tester.e4().insertColumns(new String[]{"c_timestamp"}).values(new Object[]{dateTime}).exec();
        tester.target("/e4").queryParam("include", new Object[]{E4.C_TIMESTAMP.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"cTimestamp\":\"2012-02-03T11:01:02\"}"});
    }

    @Test
    public void dateAsUtilDate() {
        LocalDate date = LocalDate.of(2012, 2, 3);
        tester.e4().insertColumns(new String[]{"c_date"}).values(new Object[]{date}).exec();
        tester.target("/e4").queryParam("include", new Object[]{E4.C_DATE.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"cDate\":\"2012-02-03T00:00:00\"}"});
    }

    @Test
    public void timeAsUtilDate() {
        LocalTime lt = LocalTime.of(14, 0, 1);
        tester.e4().insertColumns(new String[]{"c_time"}).values(new Object[]{lt}).exec();
        tester.target("/e4").queryParam("include", new Object[]{E4.C_TIME.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"cTime\":\"1970-01-01T14:00:01\"}"});
    }

    @Test
    public void sqlTimestamp() {
        LocalDateTime ts = LocalDateTime.of(2012, 2, 3, 11, 1, 2);
        tester.e19().insertColumns(new String[]{"id", "c_timestamp"}).values(new Object[]{35, ts}).exec();
        tester.target("/e19/35").queryParam("include", new Object[]{E19.C_TIMESTAMP.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"cTimestamp\":\"2012-02-03T11:01:02\"}"});
    }

    @Test
    public void sqlDate() {
        LocalDate date = LocalDate.of(2012, 2, 3);
        tester.e19().insertColumns(new String[]{"id", "c_date"}).values(new Object[]{35, date}).exec();
        tester.target("/e19/35").queryParam("include", new Object[]{E19.C_DATE.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"cDate\":\"2012-02-03\"}"});
    }

    @Test
    public void sqlTime() {
        LocalTime t = LocalTime.of(14, 0, 1);
        tester.e19().insertColumns(new String[]{"id", "c_time"}).values(new Object[]{35, t}).exec();
        tester.target("/e19/35").queryParam("include", new Object[]{E19.C_TIME.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"cTime\":\"14:00:01\"}"});
    }

    @Test
    public void byteArray() {
        tester.e19().insertColumns(new String[]{"id", "guid"}).values(new Object[]{35, "someValue123".getBytes(StandardCharsets.UTF_8)}).exec();
        tester.target("/e19/35").queryParam("include", new Object[]{E19.GUID.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"guid\":\"c29tZVZhbHVlMTIz\"}"});
    }

    @Test
    public void _boolean() {
        tester.e19().insertColumns(new String[]{"id", "boolean_object", "boolean_primitive"}).values(new Object[]{35, true, true}).exec();
        tester.target("/e19/35").queryParam("include", new Object[]{E19.BOOLEAN_OBJECT.getName(), E19.BOOLEAN_PRIMITIVE.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"booleanObject\":true,\"booleanPrimitive\":true}"});
    }

    @Test
    public void _byte() {
        tester.e19().insertColumns(new String[]{"id", "byte_object", "byte_primitive"}).values(new Object[]{35, 1, 2}).exec();
        tester.target("/e19/35").queryParam("include", new Object[]{E19.BYTE_OBJECT.getName(), E19.BYTE_PRIMITIVE.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"byteObject\":1,\"bytePrimitive\":2}"});
    }

    @Test
    public void _short() {
        tester.e19().insertColumns(new String[]{"id", "short_object", "short_primitive"}).values(new Object[]{35, 1, 2}).exec();
        tester.target("/e19/35").queryParam("include", new Object[]{E19.SHORT_OBJECT.getName(), E19.SHORT_PRIMITIVE.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"shortObject\":1,\"shortPrimitive\":2}"});
    }

    @Test
    public void _long() {
        tester.e19().insertColumns(new String[]{"id", "long_object", "long_primitive"}).values(new Object[]{35, 13434234234L, 13434234235L}).exec();
        tester.target("/e19/35").queryParam("include", new Object[]{E19.LONG_OBJECT.getName(), E19.LONG_PRIMITIVE.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"longObject\":13434234234,\"longPrimitive\":13434234235}"});
    }

    @Test
    public void bigInteger() {
        tester.e19().insertColumns(new String[]{"id", "big_integer"}).values(new Object[]{35, new BigInteger("1234567890")}).exec();
        tester.target("/e19/35").queryParam("include", new Object[]{E19.BIG_INTEGER.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"bigInteger\":1234567890}"});
    }

    @Test
    public void bigDecimal() {
        tester.e19().insertColumns(new String[]{"id", "big_decimal"}).values(new Object[]{35, new BigDecimal("123456789.12")}).exec();
        tester.target("/e19/35").queryParam("include", new Object[]{E19.BIG_DECIMAL.getName()}).get().wasOk().bodyEquals(1L, new String[]{"{\"bigDecimal\":123456789.12}"});
    }

    @Test
    public void json() {
        tester.e28().insertColumns(new String[]{"id", "json"}).values(new Object[]{35, "[1,2]"}).values(new Object[]{36, "{\"a\":1}"}).values(new Object[]{37, "{}"}).values(new Object[]{38, "5"}).values(new Object[]{39, null}).exec();
        tester.target("/e28").queryParam("include", new Object[]{E28.JSON.getName()}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(5L, new String[]{"{\"json\":[1,2]}", "{\"json\":{\"a\":1}}", "{\"json\":{}}", "{\"json\":5}", "{\"json\":null}"});
    }

    @Test
    public void json_WithOtherProps() {
        tester.e28().insertColumns(new String[]{"id", "json"}).values(new Object[]{35, "[1,2]"}).values(new Object[]{37, "{}"}).exec();
        tester.target("/e28/expanded").queryParam("include", new Object[]{"a", E28.JSON.getName(), "z"}).queryParam("sort", new Object[]{"id"}).get().wasOk().bodyEquals(2L, new String[]{"{\"a\":\"A\",\"json\":[1,2],\"z\":\"Z\"}", "{\"a\":\"A\",\"json\":{},\"z\":\"Z\"}"});
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e4")
        public DataResponse<E4> getE4(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E4.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e4/{id}")
        public DataResponse<E4> getE4_WithIncludeExclude(@PathParam(value="id") int id, @Context UriInfo uriInfo) {
            return AgJaxrs.select(E4.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).byId((Object)id).get();
        }

        @GET
        @Path(value="e19/{id}")
        public DataResponse<E19> getById(@Context UriInfo uriInfo, @PathParam(value="id") Integer id) {
            return AgJaxrs.select(E19.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).byId((Object)id).getOne();
        }

        @GET
        @Path(value="e28")
        public DataResponse<E28> get28(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E28.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e28/expanded")
        public DataResponse<E28> get28Expanded(@Context UriInfo uriInfo) {
            AgEntityOverlay overlay = AgEntity.overlay(E28.class).attribute("a", String.class, o -> "A").attribute("z", String.class, o -> "Z");
            return AgJaxrs.select(E28.class, (Configuration)this.config).entityOverlay(overlay).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

