/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

@Deprecated
public class CayenneExpIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = CayenneExpIT.tester(Resource.class).entities(E2.class, E3.class).build();

    @Test
    public void map() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).values(new Object[]{3, "zzz"}).exec();
        tester.target("/e2").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"{\"exp\":\"name = 'yyy'\"}"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":2}"});
    }

    @Test
    public void map_Params() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).values(new Object[]{3, "zzz"}).exec();
        tester.target("/e2").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"{\"exp\":\"name = $n\",\"params\":{\"n\":\"xxx\"}}"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1}"});
    }

    @Test
    public void bare() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).values(new Object[]{3, "zzz"}).exec();
        tester.target("/e2").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"name = 'yyy'"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":2}"});
    }

    @Test
    public void list() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).values(new Object[]{3, "zzz"}).exec();
        tester.target("/e2").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"[\"name = 'yyy'\"]"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":2}"});
    }

    @Test
    public void list_Params() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).values(new Object[]{3, "zzz"}).exec();
        tester.target("/e2").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"[\"name = $b\", \"xxx\"]"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":1}"});
    }

    @Test
    public void in_Array() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).values(new Object[]{3, "zzzz"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{6, "yyy", 3}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", 2}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"{\"exp\":\"e2 in $ids\",\"params\":{\"ids\": [3, 4]}}"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":6}"});
    }

    @Test
    public void notIn_Array() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", 2}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"{\"exp\":\"e2 not in $ids\",\"params\":{\"ids\": [1, 2]}}"}).get().wasOk().bodyEquals(0L, new String[]{""});
    }

    @Test
    public void outer() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "A", 1}).values(new Object[]{9, "B", null}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"{\"exp\":\"e2+.name = null\"}"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":9}"});
    }

    @Test
    public void outer_Relationship() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "A", 1}).values(new Object[]{9, "B", null}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"{\"exp\":\"e2+ = null\"}"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":9}"});
    }

    @Test
    public void outer_To_Many_Relationship() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "A", 1}).values(new Object[]{9, "B", null}).exec();
        tester.target("/e2").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"{\"exp\":\"e3s+ = null\"}"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":2}"});
    }

    @Test
    public void in_TwoObjects() {
        tester.e3().insertColumns(new String[]{"id_", "name"}).values(new Object[]{8, "yyy"}).values(new Object[]{9, "zzz"}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"{\"exp\":\"name in ($n1, $n2)\",\"params\":{\"n1\":\"zzz\",\"n2\":\"xxx\"}}"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":9}"});
    }

    @Test
    public void in_TwoRelatedObjects() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", 2}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"{\"exp\":\"e2.name in ($n1, $n2)\",\"params\":{\"n1\":\"zzz\",\"n2\":\"xxx\"}}"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":8}"});
    }

    @Test
    public void notIn_ById() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", 2}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"{\"exp\":\"e2 not in ($id)\",\"params\":{\"id\":1}}"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":9}"});
    }

    @Test
    public void notIn_By2Ids() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", 2}).exec();
        tester.target("/e3").queryParam("include", new Object[]{"id"}).queryParam("cayenneExp", new Object[]{"{\"exp\":\"e2 not in ($id1, $id2)\",\"params\":{\"id1\":1,\"id2\":3}}"}).get().wasOk().bodyEquals(1L, new String[]{"{\"id\":9}"});
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e2")
        public DataResponse<E2> getE2(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E2.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }

        @GET
        @Path(value="e3")
        public DataResponse<E3> getE3(@Context UriInfo uriInfo) {
            return AgJaxrs.select(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).get();
        }
    }
}

