/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.GET;

import io.agrest.AgRequest;
import io.agrest.DataResponse;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.agrest.protocol.Exp;
import io.agrest.protocol.Sort;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class AgRequestIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = AgRequestIT.tester(Resource.class).entities(E2.class, E3.class, E4.class).build();

    @Test
    public void exp_OverrideByAgRequest() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).values(new Object[]{3, "zzz"}).exec();
        tester.target("/e2_exp").queryParam("include", new Object[]{"name"}).queryParam("exp", new Object[]{"{\"exp\":\"name = 'yyy'\"}"}).get().wasOk().bodyEquals(1L, new String[]{"{\"name\":\"xxx\"}"});
    }

    @Test
    public void includes_OverrideByAgRequest() {
        tester.e3().insertColumns(new String[]{"id_", "name"}).values(new Object[]{6, "yyy"}).values(new Object[]{8, "yyy"}).values(new Object[]{9, "zzz"}).exec();
        tester.target("/e3_includes").queryParam("include", new Object[]{"id"}).queryParam("exp", new Object[]{"{\"exp\":\"name = 'yyy'\"}"}).get().wasOk().bodyEquals(2L, new String[]{"{\"name\":\"yyy\"}", "{\"name\":\"yyy\"}"});
    }

    @Test
    public void excludes_OverrideByAgRequest() {
        tester.e3().insertColumns(new String[]{"id_", "name"}).values(new Object[]{6, "yyy"}).values(new Object[]{8, "yyy"}).values(new Object[]{9, "zzz"}).exec();
        tester.target("/e3_excludes").queryParam("exclude", new Object[]{"name"}).queryParam("exp", new Object[]{"{\"exp\":\"name = 'yyy'\"}"}).get().wasOk().bodyEquals(2L, new String[]{"{\"name\":\"yyy\",\"phoneNumber\":null}", "{\"name\":\"yyy\",\"phoneNumber\":null}"});
    }

    @Test
    public void sort_OverrideByAgRequest() {
        tester.e4().insertColumns(new String[]{"id"}).values(new Object[]{2}).values(new Object[]{1}).values(new Object[]{3}).exec();
        tester.target("/e4_sort").queryParam("sort", new Object[]{"[{\"property\":\"id\",\"direction\":\"DESC\"}]"}).queryParam("include", new Object[]{"id"}).get().wasOk().bodyEquals(3L, new String[]{"{\"id\":1},{\"id\":2},{\"id\":3}"});
    }

    @Test
    public void mapBy_OverrideByAgRequest() {
        tester.e4().insertColumns(new String[]{"c_varchar", "c_int"}).values(new Object[]{"xxx", 1}).values(new Object[]{"yyy", 2}).values(new Object[]{"zzz", 2}).values(new Object[]{"xxx", 3}).exec();
        tester.target("/e4_mapBy").queryParam("mapBy", new Object[]{E4.C_INT.getName()}).queryParam("include", new Object[]{E4.C_VARCHAR.getName()}).get().wasOk().bodyEqualsMapBy(4L, new String[]{"\"xxx\":[{\"cVarchar\":\"xxx\"},{\"cVarchar\":\"xxx\"}]", "\"yyy\":[{\"cVarchar\":\"yyy\"}]", "\"zzz\":[{\"cVarchar\":\"zzz\"}]"});
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="e2_exp")
        public DataResponse<E2> getE2(@Context UriInfo uriInfo) {
            Exp exp = Exp.parse((String)"name = 'xxx'");
            AgRequest agRequest = AgJaxrs.request((Configuration)this.config).andExp(exp).build();
            return AgJaxrs.select(E2.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).request(agRequest).get();
        }

        @GET
        @Path(value="e3_includes")
        public DataResponse<E3> getE3_includes(@Context UriInfo uriInfo) {
            AgRequest agRequest = AgJaxrs.request((Configuration)this.config).addInclude("name").build();
            return AgJaxrs.select(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).request(agRequest).get();
        }

        @GET
        @Path(value="e3_excludes")
        public DataResponse<E3> getE3_excludes(@Context UriInfo uriInfo) {
            AgRequest agRequest = AgJaxrs.request((Configuration)this.config).addExclude("id").build();
            return AgJaxrs.select(E3.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).request(agRequest).get();
        }

        @GET
        @Path(value="e4_sort")
        public DataResponse<E4> getE4_sort(@Context UriInfo uriInfo) {
            AgRequest agRequest = AgJaxrs.request((Configuration)this.config).addSort(new Sort("id")).build();
            return AgJaxrs.select(E4.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).request(agRequest).get();
        }

        @GET
        @Path(value="e4_mapBy")
        public DataResponse<E4> getE4_mapBy(@Context UriInfo uriInfo) {
            AgRequest agRequest = AgJaxrs.request((Configuration)this.config).mapBy(E4.C_VARCHAR.getName()).build();
            return AgJaxrs.select(E4.class, (Configuration)this.config).clientParams((Map)uriInfo.getQueryParameters()).request(agRequest).get();
        }
    }
}

