/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.DELETE;

import io.agrest.EntityDelete;
import io.agrest.SimpleResponse;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E7;
import io.agrest.cayenne.cayenne.main.E8;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import org.junit.jupiter.api.Test;

public class RelatedIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = RelatedIT.tester(E2Resource.class, E3Resource.class, E8Resource.class).entitiesAndDependencies(E2.class, E3.class, E7.class, E8.class).build();

    @Test
    public void all_ToMany() {
        tester.e8().insertColumns(new String[]{"id", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e7().insertColumns(new String[]{"id", "name", "e8_id"}).values(new Object[]{7, "zzz", 2}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", 1}).exec();
        tester.target("/e8/1/e7s").delete().wasOk().bodyEquals("{}");
        tester.e7().matcher().eq("e8_id", (Object)1).assertNoMatches();
    }

    @Test
    public void validRel_ToMany() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{7, "zzz", 2}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", 1}).exec();
        tester.target("/e2/1/e3s/9").delete().wasOk().bodyEquals("{}");
        tester.e3().matcher().eq("id_", (Object)9).andEq("e2_id", null).assertOneMatch();
    }

    @Test
    public void validRel_ToOne() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{7, "zzz", 2}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", 1}).exec();
        tester.target("/e3/9/e2/1").delete().wasOk().bodyEquals("{}");
        tester.e3().matcher().eq("id_", (Object)9).andEq("e2_id", null).assertOneMatch();
    }

    @Test
    public void validRel_ToOne_All() {
        tester.e2().insertColumns(new String[]{"id_", "name"}).values(new Object[]{1, "xxx"}).values(new Object[]{2, "yyy"}).exec();
        tester.e3().insertColumns(new String[]{"id_", "name", "e2_id"}).values(new Object[]{7, "zzz", 2}).values(new Object[]{8, "yyy", 1}).values(new Object[]{9, "zzz", 1}).exec();
        tester.target("/e3/9/e2").delete().wasOk().bodyEquals("{}");
        tester.e3().matcher().eq("id_", (Object)9).andEq("e2_id", null).assertOneMatch();
    }

    @Test
    public void invalidRel() {
        tester.target("/e2/1/dummyRel/9").delete().wasBadRequest().bodyEquals("{\"message\":\"Invalid relationship: 'dummyRel'\"}");
    }

    @Test
    public void noSuchId_Source() {
        tester.target("/e2/22/e3s/9").delete().wasNotFound().bodyEquals("{\"message\":\"No object for ID '22' and entity 'E2'\"}");
    }

    @Path(value="e2")
    public static class E2Resource {
        @Context
        private Configuration config;

        @DELETE
        @Path(value="{id}")
        public SimpleResponse deleteE2ById(@PathParam(value="id") int id) {
            return AgJaxrs.delete(E2.class, (Configuration)this.config).byId((Object)id).sync();
        }

        @Deprecated
        @DELETE
        public SimpleResponse deleteE2_Batch(Collection<EntityDelete<E2>> deleted) {
            return AgJaxrs.runtime((Configuration)this.config).delete(E2.class, deleted);
        }

        @DELETE
        @Path(value="{id}/{rel}/{tid}")
        public SimpleResponse deleteToMany(@PathParam(value="id") int id, @PathParam(value="rel") String relationship, @PathParam(value="tid") int tid) {
            return AgJaxrs.unrelate(E2.class, (Configuration)this.config).sourceId((Object)id).related(relationship, (Object)tid).sync();
        }
    }

    @Path(value="e3")
    public static class E3Resource {
        @Context
        private Configuration config;

        @DELETE
        @Path(value="{id}/e2")
        public SimpleResponse deleteE2_Implicit(@PathParam(value="id") int id) {
            return AgJaxrs.unrelate(E3.class, (Configuration)this.config).sourceId((Object)id).allRelated(E3.E2.getName()).sync();
        }

        @DELETE
        @Path(value="{id}/e2/{tid}")
        public SimpleResponse deleteE2(@PathParam(value="id") int id, @PathParam(value="tid") int tid) {
            return AgJaxrs.unrelate(E3.class, (Configuration)this.config).sourceId((Object)id).related(E3.E2.getName(), (Object)tid).sync();
        }
    }

    @Path(value="e8")
    public static class E8Resource {
        @Context
        private Configuration config;

        @DELETE
        @Path(value="{id}/e7s")
        public SimpleResponse deleteE7s(@PathParam(value="id") int id, String entityData) {
            return AgJaxrs.delete(E7.class, (Configuration)this.config).parent(E8.class, (Object)id, E8.E7S.getName()).sync();
        }
    }
}

